/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MemoryCheckpointOutputStreamTest {
    MemoryCheckpointOutputStreamTest() {
    }

    @Test
    void testOversizedState() throws Exception {
        HashMap<String, Integer> state = new HashMap<String, Integer>();
        state.put("hey there", 2);
        state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
        MemCheckpointStreamFactory.MemoryCheckpointOutputStream outStream = new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(10);
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)outStream);
        oos.writeObject(state);
        oos.flush();
        Assertions.assertThatThrownBy(() -> ((CheckpointStateOutputStream)outStream).closeAndGetHandle()).isInstanceOf(IOException.class);
    }

    @Test
    void testStateStream() throws Exception {
        HashMap<String, Integer> state = new HashMap<String, Integer>();
        state.put("hey there", 2);
        state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
        MemCheckpointStreamFactory.MemoryCheckpointOutputStream outStream = new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(0x500000);
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)outStream);
        oos.writeObject(state);
        oos.flush();
        StreamStateHandle handle = outStream.closeAndGetHandle();
        Assertions.assertThat((Object)handle).isNotNull();
        try (ObjectInputStream ois = new ObjectInputStream((InputStream)handle.openInputStream());){
            Assertions.assertThat((Object)ois.readObject()).isEqualTo(state);
            Assertions.assertThat((int)ois.available()).isLessThanOrEqualTo(0);
        }
    }
}

