/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FsStorageEntropyTest {
    static final String ENTROPY_MARKER = "__ENTROPY__";
    static final String RESOLVED_MARKER = "+RESOLVED+";
    @TempDir
    private java.nio.file.Path tmp;

    FsStorageEntropyTest() {
    }

    @Test
    void testEntropyInjection() throws Exception {
        FileStateHandle handle;
        int fileSizeThreshold = 1024;
        TestEntropyAwareFs fs = new TestEntropyAwareFs();
        Path checkpointDir = new Path(Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp)), "__ENTROPY__/checkpoints");
        String checkpointDirStr = checkpointDir.toString();
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess((FileSystem)fs, checkpointDir, null, true, new JobID(), 1024, 4096);
        storage.initializeBaseLocationsForCheckpoint();
        FsCheckpointStorageLocation location = (FsCheckpointStorageLocation)storage.initializeLocationForCheckpoint(96562L);
        Assertions.assertThat((String)location.getCheckpointDirectory().toString()).startsWith((CharSequence)checkpointDirStr);
        Assertions.assertThat((String)location.getSharedStateDirectory().toString()).startsWith((CharSequence)checkpointDirStr);
        Assertions.assertThat((String)location.getTaskOwnedStateDirectory().toString()).startsWith((CharSequence)checkpointDirStr);
        Assertions.assertThat((String)location.getMetadataFilePath().toString()).doesNotContain(new CharSequence[]{ENTROPY_MARKER});
        try (CheckpointStateOutputStream stream = storage.createTaskOwnedStateStream();){
            stream.write(new byte[1025], 0, 1025);
            handle = (FileStateHandle)stream.closeAndGetHandle();
            Assertions.assertThat((Object)handle).isNotNull();
            Assertions.assertThat((String)handle.getFilePath().toString()).doesNotContain(new CharSequence[]{ENTROPY_MARKER});
            Assertions.assertThat((String)handle.getFilePath().toString()).contains(new CharSequence[]{RESOLVED_MARKER});
        }
        stream = location.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        try {
            stream.write(new byte[1025], 0, 1025);
            handle = (FileStateHandle)stream.closeAndGetHandle();
            Assertions.assertThat((Object)handle).isNotNull();
            Assertions.assertThat((String)handle.getFilePath().toString()).doesNotContain(new CharSequence[]{ENTROPY_MARKER});
            Assertions.assertThat((String)handle.getFilePath().toString()).contains(new CharSequence[]{RESOLVED_MARKER});
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = location.createMetadataOutputStream();
        try {
            stream.flush();
            handle = (FsCompletedCheckpointStorageLocation)stream.closeAndFinalizeCheckpoint();
            Assertions.assertThat((Object)handle).isNotNull();
            Assertions.assertThat((String)handle.getMetadataHandle().getFilePath().toString()).doesNotContain(new CharSequence[]{ENTROPY_MARKER});
            Assertions.assertThat((String)handle.getMetadataHandle().getFilePath().toString()).doesNotContain(new CharSequence[]{ENTROPY_MARKER});
            Assertions.assertThat((String)handle.getExternalPointer()).isEqualTo(handle.getMetadataHandle().getFilePath().getParent().toString());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static class TestEntropyAwareFs
    extends LocalFileSystem
    implements EntropyInjectingFileSystem {
        TestEntropyAwareFs() {
        }

        public String getEntropyInjectionKey() {
            return FsStorageEntropyTest.ENTROPY_MARKER;
        }

        public String generateEntropy() {
            return FsStorageEntropyTest.RESOLVED_MARKER;
        }
    }
}

