/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.checkpoint.metadata.ChannelStateTestUtils;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.MergedInputChannelStateHandle;
import org.apache.flink.runtime.state.MergedResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MergedChannelStateHandleTest {
    MergedChannelStateHandleTest() {
    }

    @Test
    void testMergeInputChannelStateHandles() {
        List<InputChannelStateHandle> inputHandles = ChannelStateTestUtils.randomInputChannelStateHandlesFromSameSubtask();
        MergedInputChannelStateHandle mergedHandle = MergedInputChannelStateHandle.fromChannelHandles(inputHandles);
        Assertions.assertEquals(inputHandles, new ArrayList(mergedHandle.getUnmergedHandles()));
    }

    @Test
    void testMergeResultSubpartitionStateHandles() {
        List<ResultSubpartitionStateHandle> outputHandles = ChannelStateTestUtils.randomResultSubpartitionStateHandlesFromSameSubtask();
        MergedResultSubpartitionStateHandle mergedHandle = MergedResultSubpartitionStateHandle.fromChannelHandles(outputHandles);
        Assertions.assertEquals(outputHandles, new ArrayList(mergedHandle.getUnmergedHandles()));
    }
}

