/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.stopwithsavepoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointTerminationHandler;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointTerminationManager;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StopWithSavepointTerminationManagerTest {
    StopWithSavepointTerminationManagerTest() {
    }

    @Test
    void testCompletionInCorrectOrder() {
        this.assertCorrectOrderOfProcessing((completedSavepointFuture, terminatedExecutionStatesFuture) -> {
            completedSavepointFuture.complete(null);
            terminatedExecutionStatesFuture.complete(null);
        });
    }

    @Test
    void testCompletionInInverseOrder() {
        this.assertCorrectOrderOfProcessing((completedSavepointFuture, terminatedExecutionStatesFuture) -> {
            terminatedExecutionStatesFuture.complete(null);
            completedSavepointFuture.complete(null);
        });
    }

    private void assertCorrectOrderOfProcessing(BiConsumer<CompletableFuture<CompletedCheckpoint>, CompletableFuture<ExecutionState>> completion) {
        CompletableFuture completedSavepointFuture = new CompletableFuture();
        CompletableFuture terminatedExecutionStateFuture = new CompletableFuture();
        TestingStopWithSavepointTerminationHandler stopWithSavepointTerminationHandler = new TestingStopWithSavepointTerminationHandler();
        new StopWithSavepointTerminationManager((StopWithSavepointTerminationHandler)stopWithSavepointTerminationHandler).stopWithSavepoint(completedSavepointFuture, (CompletableFuture)terminatedExecutionStateFuture.thenApply(Collections::singleton), ComponentMainThreadExecutorServiceAdapter.forMainThread());
        completion.accept(completedSavepointFuture, terminatedExecutionStateFuture);
        Assertions.assertThat(stopWithSavepointTerminationHandler.getActualMethodCallOrder()).containsAll(Arrays.asList(MethodCall.SavepointCreationTermination, MethodCall.ExecutionTermination));
    }

    private static class TestingStopWithSavepointTerminationHandler
    implements StopWithSavepointTerminationHandler {
        private final List<MethodCall> methodCalls = new ArrayList<MethodCall>(2);

        private TestingStopWithSavepointTerminationHandler() {
        }

        public CompletableFuture<String> getSavepointPath() {
            return FutureUtils.completedExceptionally((Throwable)new Exception("The result is not relevant in this test."));
        }

        public void handleSavepointCreation(CompletedCheckpoint completedSavepoint, Throwable throwable) {
            this.methodCalls.add(MethodCall.SavepointCreationTermination);
        }

        public void handleExecutionsTermination(Collection<ExecutionState> terminatedExecutionStates) {
            this.methodCalls.add(MethodCall.ExecutionTermination);
        }

        public List<MethodCall> getActualMethodCallOrder() {
            return this.methodCalls;
        }
    }

    private static enum MethodCall {
        SavepointCreationTermination,
        ExecutionTermination;

    }
}

