/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.flink.runtime.scheduler.exceptionhistory.ArchivedTaskManagerLocationMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class ExceptionHistoryEntryMatcher
implements Predicate<ExceptionHistoryEntry> {
    private final Throwable expectedException;
    private final long expectedTimestamp;
    private final Map<String, String> expectedFailureLabels;
    private final String expectedTaskName;
    private final ArchivedTaskManagerLocationMatcher taskManagerLocationMatcher;

    public static Predicate<ExceptionHistoryEntry> matchesGlobalFailure(Throwable expectedException, long expectedTimestamp, Map<String, String> expectedFailureLabels) {
        return ExceptionHistoryEntryMatcher.matchesFailure(expectedException, expectedTimestamp, expectedFailureLabels, null, null);
    }

    public static Predicate<ExceptionHistoryEntry> matchesFailure(Throwable expectedException, long expectedTimestamp, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        return new ExceptionHistoryEntryMatcher(expectedException, expectedTimestamp, Collections.emptyMap(), expectedTaskName, expectedTaskManagerLocation);
    }

    public static Predicate<ExceptionHistoryEntry> matchesFailure(Throwable expectedException, long expectedTimestamp, Map<String, String> expectedFailureLabels, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        return new ExceptionHistoryEntryMatcher(expectedException, expectedTimestamp, expectedFailureLabels, expectedTaskName, expectedTaskManagerLocation);
    }

    public ExceptionHistoryEntryMatcher(Throwable expectedException, long expectedTimestamp, Map<String, String> expectedFailureLabels, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        this.expectedException = expectedException;
        this.expectedTimestamp = expectedTimestamp;
        this.expectedFailureLabels = expectedFailureLabels;
        this.expectedTaskName = expectedTaskName;
        this.taskManagerLocationMatcher = new ArchivedTaskManagerLocationMatcher(expectedTaskManagerLocation);
    }

    @Override
    public boolean test(ExceptionHistoryEntry exceptionHistoryEntry) {
        boolean match = true;
        if (!exceptionHistoryEntry.getException().deserializeError(ClassLoader.getSystemClassLoader()).equals(this.expectedException)) {
            match = false;
        }
        if (exceptionHistoryEntry.getTimestamp() != this.expectedTimestamp) {
            match = false;
        }
        if (!exceptionHistoryEntry.getFailureLabelsFuture().equals(this.expectedFailureLabels)) {
            match = false;
        }
        if (exceptionHistoryEntry.getFailingTaskName() == null) {
            if (this.expectedTaskName != null) {
                match = false;
            }
        } else if (exceptionHistoryEntry.getFailingTaskName().equals(this.expectedTaskName)) {
            match = false;
        }
        return match |= this.taskManagerLocationMatcher.test(exceptionHistoryEntry.getTaskManagerLocation());
    }
}

