/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.util.FlinkException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateWithExecutionGraphTest {
    private static final Logger log = LoggerFactory.getLogger(StateWithExecutionGraphTest.class);

    StateWithExecutionGraphTest() {
    }

    @Test
    void testSuspendCanBeCalledWhenExecutionGraphHasReachedGloballyTerminalState() throws Exception {
        try (MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph testingExecutionGraph = new StateTrackingMockExecutionGraph();
            testingExecutionGraph.transitionToRunning();
            TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, testingExecutionGraph);
            context.setExpectFinished(archivedExecutionGraph -> Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED));
            testingExecutionGraph.failJob((Throwable)new FlinkException("Transition job to FAILED state"), System.currentTimeMillis());
            testingExecutionGraph.completeTerminationFuture(JobStatus.FAILED);
            Assertions.assertThat((Comparable)testingExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED);
            FlinkAssertions.assertThatFuture(stateWithExecutionGraph.getGloballyTerminalStateFuture()).isNotDone();
            stateWithExecutionGraph.suspend((Throwable)new FlinkException("Test exception"));
        }
    }

    @Test
    void testOperatorCoordinatorShutdownOnLeave() throws Exception {
        try (MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();){
            TestingOperatorCoordinatorHandler testingOperatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
            TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, testingOperatorCoordinatorHandler);
            stateWithExecutionGraph.onLeave(AdaptiveSchedulerTest.DummyState.class);
            Assertions.assertThat((boolean)testingOperatorCoordinatorHandler.isDisposed()).isTrue();
        }
    }

    @Test
    void testSuspendToFinished() throws Exception {
        try (MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();){
            TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context);
            context.setExpectFinished(aeg -> Assertions.assertThat((Comparable)aeg.getState()).isEqualTo((Object)JobStatus.SUSPENDED));
            stateWithExecutionGraph.suspend(new RuntimeException());
        }
    }

    @Test
    void testOnGloballyTerminalStateCalled() throws Exception {
        MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();
        StateTrackingMockExecutionGraph mockExecutionGraph = new StateTrackingMockExecutionGraph();
        TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, mockExecutionGraph);
        mockExecutionGraph.completeTerminationFuture(JobStatus.FINISHED);
        context.close();
        FlinkAssertions.assertThatFuture(stateWithExecutionGraph.getGloballyTerminalStateFuture()).isCompletedWithValue((Object)JobStatus.FINISHED);
    }

    @Test
    void testOnGloballyTerminalStateNotCalledOnNonGloballyTerminalState() throws Exception {
        MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();
        StateTrackingMockExecutionGraph mockExecutionGraph = new StateTrackingMockExecutionGraph();
        TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, mockExecutionGraph);
        mockExecutionGraph.completeTerminationFuture(JobStatus.SUSPENDED);
        context.close();
        FlinkAssertions.assertThatFuture(stateWithExecutionGraph.getGloballyTerminalStateFuture()).isNotDone();
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context) {
        StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
        return this.createStateWithExecutionGraph(context, executionGraph);
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context, OperatorCoordinatorHandler operatorCoordinatorHandler) {
        StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
        return this.createStateWithExecutionGraph(context, executionGraph, operatorCoordinatorHandler);
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context, ExecutionGraph executionGraph) {
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        return this.createStateWithExecutionGraph(context, executionGraph, operatorCoordinatorHandler);
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context, ExecutionGraph executionGraph, OperatorCoordinatorHandler operatorCoordinatorHandler) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, log, (Executor)context.getMainThreadExecutor(), context.getMainThreadExecutor());
        executionGraph.transitionToRunning();
        return new TestingStateWithExecutionGraph(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, log, ClassLoader.getSystemClassLoader());
    }

    private static final class TestingStateWithExecutionGraph
    extends StateWithExecutionGraph {
        private final CompletableFuture<JobStatus> globallyTerminalStateFuture = new CompletableFuture();

        TestingStateWithExecutionGraph(StateWithExecutionGraph.Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, ClassLoader userCodeClassLoader) {
            super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger, userCodeClassLoader, new ArrayList());
        }

        public CompletableFuture<JobStatus> getGloballyTerminalStateFuture() {
            return this.globallyTerminalStateFuture;
        }

        public void cancel() {
        }

        public JobStatus getJobStatus() {
            return this.getExecutionGraph().getState();
        }

        void onFailure(Throwable cause, CompletableFuture<Map<String, String>> failureLabels) {
        }

        void onGloballyTerminalState(JobStatus globallyTerminalState) {
            this.globallyTerminalStateFuture.complete(globallyTerminalState);
        }

        public void handleGlobalFailure(Throwable cause, CompletableFuture<Map<String, String>> failureLabels) {
        }

        boolean updateTaskExecutionState(TaskExecutionStateTransition taskExecutionStateTransition, CompletableFuture<Map<String, String>> failureLabels) {
            return false;
        }
    }
}

