/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AbstractMetricsHeadersTest {
    private AbstractMetricsHeaders<EmptyMessageParameters> metricsHandlerHeaders;

    AbstractMetricsHeadersTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.metricsHandlerHeaders = new AbstractMetricsHeaders<EmptyMessageParameters>(){

            public EmptyMessageParameters getUnresolvedMessageParameters() {
                return EmptyMessageParameters.getInstance();
            }

            public String getTargetRestEndpointURL() {
                return "/";
            }

            public String getDescription() {
                return "";
            }
        };
    }

    @Test
    void testHttpMethod() {
        Assertions.assertThat((Comparable)this.metricsHandlerHeaders.getHttpMethod()).isEqualTo((Object)HttpMethodWrapper.GET);
    }

    @Test
    void testResponseStatus() {
        Assertions.assertThat((Comparable)this.metricsHandlerHeaders.getResponseStatusCode()).isEqualTo((Object)HttpResponseStatus.OK);
    }

    @Test
    void testRequestClass() {
        Assertions.assertThat((Class)this.metricsHandlerHeaders.getRequestClass()).isEqualTo(EmptyRequestBody.class);
    }

    @Test
    void testResponseClass() {
        Assertions.assertThat((Class)this.metricsHandlerHeaders.getResponseClass()).isEqualTo(MetricCollectionResponseBody.class);
    }
}

