/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.SubtaskIndexPathParameter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SubtaskIndexPathParameterTest {
    private SubtaskIndexPathParameter subtaskIndexPathParameter;

    SubtaskIndexPathParameterTest() {
    }

    @BeforeEach
    void setUp() {
        this.subtaskIndexPathParameter = new SubtaskIndexPathParameter();
    }

    @Test
    void testConversionFromString() throws Exception {
        Assertions.assertThat((Integer)this.subtaskIndexPathParameter.convertFromString("2147483647")).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    void testConversionFromStringNegativeNumber() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.subtaskIndexPathParameter.convertFromString("-2147483648")).isInstanceOf(ConversionException.class)).hasMessage("subtaskindex must be positive, was: -2147483648");
    }

    @Test
    void testConvertToString() throws Exception {
        Assertions.assertThat((String)this.subtaskIndexPathParameter.convertToString(Integer.valueOf(Integer.MAX_VALUE))).isEqualTo("2147483647");
    }

    @Test
    void testIsMandatoryParameter() {
        Assertions.assertThat((boolean)this.subtaskIndexPathParameter.isMandatory()).isTrue();
    }
}

