/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.time.Duration;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerFileHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;

public class TestingTaskManagerFileHandler
extends AbstractTaskManagerFileHandler<TaskManagerMessageParameters> {
    private final Queue<CompletableFuture<TransientBlobKey>> requestFileUploads;
    private final ResourceID expectedTaskManagerId;

    public TestingTaskManagerFileHandler(@Nonnull GatewayRetriever<? extends RestfulGateway> leaderRetriever, @Nonnull Duration timeout, @Nonnull Map<String, String> responseHeaders, @Nonnull UntypedResponseMessageHeaders<EmptyRequestBody, TaskManagerMessageParameters> untypedResponseMessageHeaders, @Nonnull GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, @Nonnull TransientBlobService transientBlobService, @Nonnull Duration cacheEntryDuration, Queue<CompletableFuture<TransientBlobKey>> requestFileUploads, ResourceID expectedTaskManagerId) {
        super(leaderRetriever, timeout, responseHeaders, untypedResponseMessageHeaders, resourceManagerGatewayRetriever, transientBlobService, cacheEntryDuration);
        this.requestFileUploads = (Queue)Preconditions.checkNotNull(requestFileUploads);
        this.expectedTaskManagerId = (ResourceID)Preconditions.checkNotNull((Object)expectedTaskManagerId);
    }

    protected CompletableFuture<TransientBlobKey> requestFileUpload(ResourceManagerGateway resourceManagerGateway, Tuple2<ResourceID, String> taskManagerIdAndFileName) {
        Assertions.assertThat((Object)((ResourceID)taskManagerIdAndFileName.f0)).isEqualTo((Object)this.expectedTaskManagerId);
        CompletableFuture<TransientBlobKey> transientBlobKeyFuture = this.requestFileUploads.poll();
        if (transientBlobKeyFuture != null) {
            return transientBlobKeyFuture;
        }
        return FutureUtils.completedExceptionally((Throwable)new FlinkException("Could not upload file."));
    }
}

