/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobStatusInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.job.JobStatusHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobStatusInfoHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.testutils.TestingUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobStatusHandlerTest {
    JobStatusHandlerTest() {
    }

    @Test
    void testRequestJobStatus() throws Exception {
        JobStatusHandler jobStatusHandler = new JobStatusHandler(CompletableFuture::new, TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)JobStatusInfoHeaders.getInstance());
        HandlerRequest<EmptyRequestBody> request = JobStatusHandlerTest.createRequest(new JobID());
        CompletableFuture response = jobStatusHandler.handleRequest(request, (RestfulGateway)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(ignored -> CompletableFuture.completedFuture(JobStatus.INITIALIZING))).build());
        Assertions.assertThat((Comparable)JobStatus.INITIALIZING).isEqualTo((Object)((JobStatusInfo)response.get()).getJobStatus());
    }

    private static HandlerRequest<EmptyRequestBody> createRequest(JobID jobId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", jobId.toString());
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobMessageParameters(), pathParameters, Collections.emptyMap(), Collections.emptyList());
    }
}

