/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LargeRecordHandlerTest {
    LargeRecordHandlerTest() {
    }

    @Test
    void testEmptyRecordHandler() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 50;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(204800L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List memory = memMan.allocatePages((Object)owner, 50);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, String>>(){});
            TupleSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, memory, (TaskInvokable)owner, 128, owner.getExecutionConfig());
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            handler.close();
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            handler.close();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.addRecord((Object)new Tuple2((Object)92L, (Object)"peter pepper"))).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalStateException.class);
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testRecordHandlerSingleKey() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 24;
        int NUM_RECORDS = 25000;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            Tuple2 next;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(98304L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List initialMemory = memMan.allocatePages((Object)owner, 6);
            List sortMemory = memMan.allocatePages((Object)owner, 18);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, String>>(){});
            TupleSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, initialMemory, (TaskInvokable)owner, 128, owner.getExecutionConfig());
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            Random rnd = new Random();
            for (int i = 0; i < 25000; ++i) {
                long val = rnd.nextLong();
                handler.addRecord((Object)new Tuple2((Object)val, (Object)String.valueOf(val)));
                Assertions.assertThat((boolean)handler.hasData()).isTrue();
            }
            MutableObjectIterator sorted = handler.finishWriteAndSortKeys(sortMemory);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.addRecord((Object)new Tuple2((Object)92L, (Object)"peter pepper"))).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalStateException.class);
            Tuple2 previous = null;
            while ((next = (Tuple2)sorted.next(null)) != null) {
                Assertions.assertThat((Long)((Long)next.f0)).isEqualTo(Long.parseLong((String)next.f1));
                if (previous != null) {
                    Assertions.assertThat((Long)((Long)previous.f0)).isLessThanOrEqualTo((Comparable)((Long)next.f0));
                }
                previous = next;
            }
            handler.close();
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            handler.close();
            try {
                handler.addRecord((Object)new Tuple2((Object)92L, (Object)"peter pepper"));
                Assertions.fail((String)"should throw an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testRecordHandlerCompositeKey() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 24;
        int NUM_RECORDS = 25000;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            Tuple3 next;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(98304L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List initialMemory = memMan.allocatePages((Object)owner, 6);
            List sortMemory = memMan.allocatePages((Object)owner, 18);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInformation.of((TypeHint)new TypeHint<Tuple3<Long, String, Byte>>(){});
            TupleSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
            TypeComparator comparator = typeInfo.createComparator(new int[]{2, 0}, new boolean[]{true, true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, initialMemory, (TaskInvokable)owner, 128, owner.getExecutionConfig());
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            Random rnd = new Random();
            for (int i = 0; i < 25000; ++i) {
                long val = rnd.nextLong();
                handler.addRecord((Object)new Tuple3((Object)val, (Object)String.valueOf(val), (Object)((byte)val)));
                Assertions.assertThat((boolean)handler.hasData()).isTrue();
            }
            MutableObjectIterator sorted = handler.finishWriteAndSortKeys(sortMemory);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.addRecord((Object)new Tuple3((Object)92L, (Object)"peter pepper", (Object)1))).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalStateException.class);
            Tuple3 previous = null;
            while ((next = (Tuple3)sorted.next(null)) != null) {
                Assertions.assertThat((Long)((Long)next.f0)).isEqualTo(Long.parseLong((String)next.f1));
                Assertions.assertThat((byte)((Long)next.f0).byteValue()).isEqualTo(next.f2);
                if (previous != null) {
                    Assertions.assertThat((Byte)((Byte)previous.f2)).isLessThanOrEqualTo((Comparable)((Byte)next.f2));
                    Assertions.assertThat((((Byte)previous.f2).byteValue() != ((Byte)next.f2).byteValue() || (Long)previous.f0 <= (Long)next.f0 ? 1 : 0) != 0).isTrue();
                }
                previous = next;
            }
            handler.close();
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            handler.close();
            try {
                handler.addRecord((Object)new Tuple3((Object)92L, (Object)"peter pepper", (Object)1));
                Assertions.fail((String)"should throw an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

