/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.FlatMapDriver;
import org.apache.flink.runtime.operators.chaining.ChainedFlatMapDriver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.operators.testutils.TaskTestBase;
import org.apache.flink.runtime.operators.testutils.UniformRecordGenerator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.testutils.recordutils.RecordSerializerFactory;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChainedOperatorsMetricTest
extends TaskTestBase {
    private static final int MEMORY_MANAGER_SIZE = 0x300000;
    private static final int NETWORK_BUFFER_SIZE = 1024;
    private static final TypeSerializerFactory<Record> serFact = RecordSerializerFactory.get();
    private final List<Record> outList = new ArrayList<Record>();
    private static final String HEAD_OPERATOR_NAME = "headoperator";
    private static final String CHAINED_OPERATOR_NAME = "chainedoperator";

    @Test
    void testOperatorIOMetricReuse() throws Exception {
        this.initEnvironment(0x300000L, 1024);
        this.mockEnv = new MockEnvironmentBuilder().setTaskName(HEAD_OPERATOR_NAME).setManagedMemorySize(0x300000L).setInputSplitProvider(this.inputSplitProvider).setBufferSize(1024).setMetricGroup(TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)NoOpMetricRegistry.INSTANCE, (String)"host", (ResourceID)ResourceID.generate()).addJob(new JobID(), "jobName").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(), "task")).build();
        int keyCnt = 100;
        int valCnt = 20;
        int numRecords = 2000;
        this.addInput(new UniformRecordGenerator(100, 20, false), 0);
        this.addOutput(this.outList);
        this.addChainedOperator();
        this.registerTask(FlatMapDriver.class, DuplicatingFlatMapFunction.class);
        BatchTask testTask = new BatchTask((Environment)this.mockEnv);
        testTask.invoke();
        Assertions.assertThat(this.outList).hasSize(8000);
        TaskMetricGroup taskMetricGroup = this.mockEnv.getMetricGroup();
        TaskIOMetricGroup ioMetricGroup = taskMetricGroup.getIOMetricGroup();
        Counter numRecordsInCounter = ioMetricGroup.getNumRecordsInCounter();
        Counter numRecordsOutCounter = ioMetricGroup.getNumRecordsOutCounter();
        Assertions.assertThat((long)numRecordsInCounter.getCount()).isEqualTo(2000L);
        Assertions.assertThat((long)numRecordsOutCounter.getCount()).isEqualTo(8000L);
        InternalOperatorMetricGroup operatorMetricGroup1 = taskMetricGroup.getOrAddOperator(HEAD_OPERATOR_NAME);
        OperatorIOMetricGroup ioMetricGroup2 = operatorMetricGroup1.getIOMetricGroup();
        Counter numRecordsInCounter2 = ioMetricGroup2.getNumRecordsInCounter();
        Counter numRecordsOutCounter2 = ioMetricGroup2.getNumRecordsOutCounter();
        Assertions.assertThat((long)numRecordsInCounter2.getCount()).isEqualTo(2000L);
        Assertions.assertThat((long)numRecordsOutCounter2.getCount()).isEqualTo(4000L);
        operatorMetricGroup1 = taskMetricGroup.getOrAddOperator(CHAINED_OPERATOR_NAME);
        ioMetricGroup2 = operatorMetricGroup1.getIOMetricGroup();
        numRecordsInCounter2 = ioMetricGroup2.getNumRecordsInCounter();
        numRecordsOutCounter2 = ioMetricGroup2.getNumRecordsOutCounter();
        Assertions.assertThat((long)numRecordsInCounter2.getCount()).isEqualTo(4000L);
        Assertions.assertThat((long)numRecordsOutCounter2.getCount()).isEqualTo(8000L);
    }

    private void addChainedOperator() {
        TaskConfig chainedConfig = new TaskConfig(new Configuration());
        chainedConfig.addInputToGroup(0);
        chainedConfig.setInputSerializer(serFact, 0);
        chainedConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        chainedConfig.setOutputSerializer(serFact);
        chainedConfig.setDriverStrategy(DriverStrategy.FLAT_MAP);
        chainedConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DuplicatingFlatMapFunction.class));
        this.getTaskConfig().addChainedTask(ChainedFlatMapDriver.class, chainedConfig, CHAINED_OPERATOR_NAME);
    }

    public static class DuplicatingFlatMapFunction
    extends RichFlatMapFunction<Record, Record> {
        private static final long serialVersionUID = -1152068682935346164L;

        public void flatMap(Record value, Collector<Record> out) throws Exception {
            out.collect((Object)value);
            out.collect((Object)value);
        }
    }
}

