/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QueryScopeInfoTest {
    QueryScopeInfoTest() {
    }

    @Test
    void testJobManagerQueryScopeInfo() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)0);
        Assertions.assertThat((String)info.scope).isEmpty();
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)0);
        Assertions.assertThat((String)info.scope).isEqualTo("world");
        info = new QueryScopeInfo.JobManagerQueryScopeInfo("hello");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)0);
        Assertions.assertThat((String)info.scope).isEqualTo("hello");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)0);
        Assertions.assertThat((String)info.scope).isEqualTo("hello.world");
    }

    @Test
    void testTaskManagerQueryScopeInfo() {
        QueryScopeInfo.TaskManagerQueryScopeInfo info = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)1);
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.taskManagerID).isEqualTo("tmid");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)1);
        Assertions.assertThat((String)info.scope).isEqualTo("world");
        Assertions.assertThat((String)info.taskManagerID).isEqualTo("tmid");
        info = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid", "hello");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)1);
        Assertions.assertThat((String)info.scope).isEqualTo("hello");
        Assertions.assertThat((String)info.taskManagerID).isEqualTo("tmid");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)1);
        Assertions.assertThat((String)info.scope).isEqualTo("hello.world");
        Assertions.assertThat((String)info.taskManagerID).isEqualTo("tmid");
    }

    @Test
    void testJobQueryScopeInfo() {
        QueryScopeInfo.JobQueryScopeInfo info = new QueryScopeInfo.JobQueryScopeInfo("jobid");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)2);
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)2);
        Assertions.assertThat((String)info.scope).isEqualTo("world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        info = new QueryScopeInfo.JobQueryScopeInfo("jobid", "hello");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)2);
        Assertions.assertThat((String)info.scope).isEqualTo("hello");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)2);
        Assertions.assertThat((String)info.scope).isEqualTo("hello.world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
    }

    @Test
    void testTaskQueryScopeInfo() {
        QueryScopeInfo.TaskQueryScopeInfo info = new QueryScopeInfo.TaskQueryScopeInfo("jobid", "taskid", 2, 0);
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)3);
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)3);
        Assertions.assertThat((String)info.scope).isEqualTo("world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
        info = new QueryScopeInfo.TaskQueryScopeInfo("jobid", "taskid", 2, 0, "hello");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)3);
        Assertions.assertThat((String)info.scope).isEqualTo("hello");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)3);
        Assertions.assertThat((String)info.scope).isEqualTo("hello.world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
    }

    @Test
    void testOperatorQueryScopeInfo() {
        QueryScopeInfo.OperatorQueryScopeInfo info = new QueryScopeInfo.OperatorQueryScopeInfo("jobid", "taskid", 2, 0, "opname");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)4);
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)4);
        Assertions.assertThat((String)info.scope).isEqualTo("world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
        info = new QueryScopeInfo.OperatorQueryScopeInfo("jobid", "taskid", 2, 0, "opname", "hello");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)4);
        Assertions.assertThat((String)info.scope).isEqualTo("hello");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)4);
        Assertions.assertThat((String)info.scope).isEqualTo("hello.world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(2);
    }

    @Test
    void testJobManagerOperatorQueryScopeInfo() {
        QueryScopeInfo.JobManagerOperatorQueryScopeInfo info = new QueryScopeInfo.JobManagerOperatorQueryScopeInfo("jobid", "taskid", "opname");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)5);
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)5);
        Assertions.assertThat((String)info.scope).isEqualTo("world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        info = new QueryScopeInfo.JobManagerOperatorQueryScopeInfo("jobid", "taskid", "opname", "hello");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)5);
        Assertions.assertThat((String)info.scope).isEqualTo("hello");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
        info = info.copy("world");
        Assertions.assertThat((byte)info.getCategory()).isEqualTo((byte)5);
        Assertions.assertThat((String)info.scope).isEqualTo("hello.world");
        Assertions.assertThat((String)info.jobID).isEqualTo("jobid");
        Assertions.assertThat((String)info.vertexID).isEqualTo("taskid");
        Assertions.assertThat((String)info.operatorName).isEqualTo("opname");
    }
}

