/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.EventOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.TraceOptions;
import org.apache.flink.events.Event;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.Reporter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.metrics.util.TestCounter;
import org.apache.flink.metrics.util.TestMeter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.metrics.CollectingMetricsReporter;
import org.apache.flink.runtime.metrics.EventReporterSetup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.ReporterSetupBuilder;
import org.apache.flink.runtime.metrics.TraceReporterSetup;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.runtime.metrics.filter.DefaultReporterFilters;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricGroupTest;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestEventReporter;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.runtime.metrics.util.TestTraceReporter;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterators;
import org.apache.flink.traces.Span;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricRegistryImplTest {
    private static final char GLOBAL_DEFAULT_DELIMITER = '.';

    MetricRegistryImplTest() {
    }

    @Test
    void testIsShutdown() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        Assertions.assertThat((boolean)metricRegistry.isShutdown()).isFalse();
        metricRegistry.closeAsync().get();
        Assertions.assertThat((boolean)metricRegistry.isShutdown()).isTrue();
    }

    @Test
    void testMetricQueryServiceSetup() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        Assertions.assertThat((String)metricRegistry.getMetricQueryServiceGatewayRpcAddress()).isNull();
        metricRegistry.startQueryService((RpcService)new TestingRpcService(), new ResourceID("mqs"));
        MetricQueryServiceGateway metricQueryServiceGateway = metricRegistry.getMetricQueryServiceGateway();
        Assertions.assertThat((Object)metricQueryServiceGateway).isNotNull();
        metricRegistry.register((Metric)new SimpleCounter(), "counter", (AbstractMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup());
        boolean metricsSuccessfullyQueried = false;
        for (int x = 0; x < 10; ++x) {
            MetricDumpSerialization.MetricSerializationResult metricSerializationResult = (MetricDumpSerialization.MetricSerializationResult)metricQueryServiceGateway.queryMetrics(Duration.ofSeconds(5L)).get(5L, TimeUnit.SECONDS);
            if (metricSerializationResult.numCounters == 1) {
                metricsSuccessfullyQueried = true;
                continue;
            }
            Thread.sleep(50L);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)metricsSuccessfullyQueried).as("metrics query did not return expected result", new Object[0])).isTrue();
    }

    @Test
    void testReporterScheduling() throws Exception {
        MetricConfig config = new MetricConfig();
        config.setProperty("arg1", "hello");
        config.setProperty(MetricOptions.REPORTER_INTERVAL.key(), "50 MILLISECONDS");
        ReportCountingReporter reporter = new ReportCountingReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.singletonList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test", config, (Reporter)reporter)));
        long start = System.currentTimeMillis();
        reporter.resetCount();
        for (int x = 0; x < 10; ++x) {
            Thread.sleep(100L);
            int reportCount = reporter.getReportCount();
            long curT = System.currentTimeMillis();
            long maxAllowedReports = (curT - start) / 50L + 2L;
            ((AbstractLongAssert)Assertions.assertThat((long)maxAllowedReports).as("Too many reports were triggered.", new Object[0])).isGreaterThanOrEqualTo((long)reportCount);
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)reporter.getReportCount()).as("No report was triggered.", new Object[0])).isGreaterThan(0);
        registry.closeAsync().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testReporterIntervalParsingErrorFallsBackToDefaultValue() throws Exception {
        MetricConfig config = new MetricConfig();
        config.setProperty(MetricOptions.REPORTER_INTERVAL.key(), "1 UNICORN");
        ManuallyTriggeredScheduledExecutorService manuallyTriggeredScheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.singletonList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test", config, (Reporter)new ReportCountingReporter())), (ScheduledExecutorService)manuallyTriggeredScheduledExecutorService);
        try {
            Collection scheduledTasks = manuallyTriggeredScheduledExecutorService.getActiveScheduledTasks();
            ScheduledFuture reportTask = (ScheduledFuture)Iterators.getOnlyElement(scheduledTasks.iterator());
            Assertions.assertThat((long)reportTask.getDelay(TimeUnit.SECONDS)).isEqualTo(((Duration)MetricOptions.REPORTER_INTERVAL.defaultValue()).getSeconds());
        }
        finally {
            registry.closeAsync().get();
        }
    }

    @Test
    void testReporterNotifications() throws Exception {
        NotificationCapturingMetricReporter reporter1 = new NotificationCapturingMetricReporter();
        NotificationCapturingMetricReporter reporter2 = new NotificationCapturingMetricReporter();
        NotificationCapturingEventReporter eventReporter1 = new NotificationCapturingEventReporter();
        NotificationCapturingEventReporter eventReporter2 = new NotificationCapturingEventReporter();
        NotificationCapturingSpanReporter spanReporter1 = new NotificationCapturingSpanReporter();
        NotificationCapturingSpanReporter spanReporter2 = new NotificationCapturingSpanReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test1", (Reporter)reporter1), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test2", (Reporter)reporter2)), Arrays.asList((TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("trace_test1", (Reporter)spanReporter1), (TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("trace_test2", (Reporter)spanReporter2)), Arrays.asList((EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("event_test1", (Reporter)eventReporter1), (EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("event_test2", (Reporter)eventReporter2)));
        TaskManagerMetricGroup root = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        root.counter("rootCounter");
        root.addEvent(Event.builder(this.getClass(), (String)"TestEvent"));
        root.addSpan(Span.builder(this.getClass(), (String)"TestSpan"));
        Assertions.assertThat(reporter1.getLastAddedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter1.getLastAddedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(eventReporter1.getLastAddedEvent().map(Event::getName)).hasValue((Object)"TestEvent");
        Assertions.assertThat(spanReporter1.getLastAddedSpan().map(Span::getName)).hasValue((Object)"TestSpan");
        Assertions.assertThat(reporter2.getLastAddedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter2.getLastAddedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(eventReporter2.getLastAddedEvent().map(Event::getName)).hasValue((Object)"TestEvent");
        Assertions.assertThat(spanReporter2.getLastAddedSpan().map(Span::getName)).hasValue((Object)"TestSpan");
        root.close();
        Assertions.assertThat(reporter1.getLastRemovedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter1.getLastRemovedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(reporter2.getLastRemovedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter2.getLastRemovedMetricName()).hasValue((Object)"rootCounter");
        registry.closeAsync().get();
    }

    @Test
    void testScopeConfig() {
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_TM, (Object)"A");
        config.set(MetricOptions.SCOPE_NAMING_TM_JOB, (Object)"B");
        config.set(MetricOptions.SCOPE_NAMING_TASK, (Object)"C");
        config.set(MetricOptions.SCOPE_NAMING_OPERATOR, (Object)"D");
        ScopeFormats scopeConfig = ScopeFormats.fromConfig((Configuration)config);
        Assertions.assertThat((String)scopeConfig.getTaskManagerFormat().format()).isEqualTo("A");
        Assertions.assertThat((String)scopeConfig.getTaskManagerJobFormat().format()).isEqualTo("B");
        Assertions.assertThat((String)scopeConfig.getTaskFormat().format()).isEqualTo("C");
        Assertions.assertThat((String)scopeConfig.getOperatorFormat().format()).isEqualTo("D");
    }

    @Test
    void testConfigurableDelimiter() throws Exception {
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_DELIMITER, (Object)"_");
        config.set(MetricOptions.SCOPE_NAMING_TM, (Object)"A.B.C.D.E");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config), (Collection)ReporterSetupBuilder.METRIC_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::metricsFromConfiguration, null));
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        Assertions.assertThat((String)tmGroup.getMetricIdentifier("name")).isEqualTo("A_B_C_D_E_name");
        registry.closeAsync().get();
    }

    @Test
    void testConfigurableDelimiterForReporters() throws Exception {
        MetricConfig config1 = new MetricConfig();
        config1.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "_");
        MetricConfig config2 = new MetricConfig();
        config2.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig config3 = new MetricConfig();
        config3.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "AA");
        MetricConfig traceConfig1 = new MetricConfig();
        traceConfig1.setProperty(TraceOptions.REPORTER_SCOPE_DELIMITER.key(), "_");
        MetricConfig traceConfig2 = new MetricConfig();
        traceConfig2.setProperty(TraceOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig traceConfig3 = new MetricConfig();
        traceConfig3.setProperty(TraceOptions.REPORTER_SCOPE_DELIMITER.key(), "AA");
        MetricConfig eventConfig1 = new MetricConfig();
        eventConfig1.setProperty(EventOptions.REPORTER_SCOPE_DELIMITER.key(), "_");
        MetricConfig eventConfig2 = new MetricConfig();
        eventConfig2.setProperty(EventOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig eventConfig3 = new MetricConfig();
        eventConfig3.setProperty(EventOptions.REPORTER_SCOPE_DELIMITER.key(), "AA");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test1", config1, (Reporter)new TestReporter()), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test2", config2, (Reporter)new TestReporter()), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test3", config3, (Reporter)new TestReporter())), Arrays.asList((TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("traceTest1", traceConfig1, (Reporter)new TestTraceReporter()), (TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("traceTest2", traceConfig2, (Reporter)new TestTraceReporter()), (TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("traceTest3", traceConfig3, (Reporter)new TestTraceReporter())), Arrays.asList((EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("eventTest1", eventConfig1, (Reporter)new TestEventReporter()), (EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("eventTest2", eventConfig2, (Reporter)new TestEventReporter()), (EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("eventTest3", eventConfig3, (Reporter)new TestEventReporter())));
        Assertions.assertThat((char)registry.getDelimiter()).isEqualTo('.');
        Assertions.assertThat((char)registry.getDelimiter(0)).isEqualTo('_');
        Assertions.assertThat((char)registry.getDelimiter(1)).isEqualTo('-');
        Assertions.assertThat((char)registry.getDelimiter(2)).isEqualTo('.');
        Assertions.assertThat((char)registry.getDelimiter(3)).isEqualTo('.');
        Assertions.assertThat((char)registry.getDelimiter(-1)).isEqualTo('.');
        List traceReporters = registry.getTraceReporters();
        Assertions.assertThat((char)((MetricRegistryImpl.ReporterAndSettings)traceReporters.get(0)).getSettings().getDelimiter()).isEqualTo('_');
        Assertions.assertThat((char)((MetricRegistryImpl.ReporterAndSettings)traceReporters.get(1)).getSettings().getDelimiter()).isEqualTo('-');
        Assertions.assertThat((char)((MetricRegistryImpl.ReporterAndSettings)traceReporters.get(2)).getSettings().getDelimiter()).isEqualTo('.');
        List eventReporters = registry.getEventReporters();
        Assertions.assertThat((char)((MetricRegistryImpl.ReporterAndSettings)traceReporters.get(0)).getSettings().getDelimiter()).isEqualTo('_');
        Assertions.assertThat((char)((MetricRegistryImpl.ReporterAndSettings)traceReporters.get(1)).getSettings().getDelimiter()).isEqualTo('-');
        Assertions.assertThat((char)((MetricRegistryImpl.ReporterAndSettings)traceReporters.get(2)).getSettings().getDelimiter()).isEqualTo('.');
        registry.closeAsync().get();
    }

    @Test
    void testConfigurableDelimiterForReportersInGroup() throws Exception {
        String name = "C";
        MetricConfig config1 = new MetricConfig();
        config1.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "_");
        MetricConfig config2 = new MetricConfig();
        config2.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig config3 = new MetricConfig();
        config3.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "AA");
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_TM, (Object)"A.B");
        List<ReporterSetup> reporterConfigurations = Arrays.asList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test1", config1, (Reporter)new CollectingMetricsReporter()), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test2", config2, (Reporter)new CollectingMetricsReporter()), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test3", config3, (Reporter)new CollectingMetricsReporter()), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test4", (Reporter)new CollectingMetricsReporter()));
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config), reporterConfigurations);
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        group.counter(name);
        group.close();
        registry.closeAsync().get();
        for (ReporterSetup cfg : reporterConfigurations) {
            String delimiter = cfg.getConfiguration().getProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key());
            if (delimiter == null || delimiter.equals("AA")) {
                delimiter = String.valueOf('.');
            }
            String expected = ((String)config.get(MetricOptions.SCOPE_NAMING_TM) + ".C").replaceAll("\\.", delimiter);
            CollectingMetricsReporter reporter = (CollectingMetricsReporter)((Object)cfg.getReporter());
            for (CollectingMetricsReporter.MetricGroupAndName groupAndName : Arrays.asList(reporter.findAdded(name), reporter.findRemoved(name))) {
                Assertions.assertThat((String)groupAndName.group.getMetricIdentifier(name)).isEqualTo(expected);
                Assertions.assertThat((String)groupAndName.group.getMetricIdentifier(name, (CharacterFilter)reporter)).isEqualTo(expected);
            }
        }
    }

    @Test
    void testQueryActorShutdown() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        TestingRpcService rpcService = new TestingRpcService();
        registry.startQueryService((RpcService)rpcService, null);
        MetricQueryService queryService = (MetricQueryService)Preconditions.checkNotNull((Object)registry.getQueryService());
        registry.closeAsync().get();
        queryService.getTerminationFuture().get();
    }

    @Test
    void testExceptionIsolation() throws Exception {
        NotificationCapturingMetricReporter reporter1 = new NotificationCapturingMetricReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test1", (Reporter)new FailingReporter()), (ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test2", (Reporter)reporter1)));
        SimpleCounter metric = new SimpleCounter();
        registry.register((Metric)metric, "counter", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter1.getLastAddedMetric()).hasValue((Object)metric);
        Assertions.assertThat(reporter1.getLastAddedMetricName()).hasValue((Object)"counter");
        registry.unregister((Metric)metric, "counter", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter1.getLastRemovedMetric()).hasValue((Object)metric);
        Assertions.assertThat(reporter1.getLastRemovedMetricName()).hasValue((Object)"counter");
        registry.closeAsync().get();
    }

    @Test
    void testMetricFiltering() {
        String excludedMetricName = "excluded";
        NotificationCapturingMetricReporter reporter = new NotificationCapturingMetricReporter();
        Configuration reporterConfig = new Configuration();
        reporterConfig.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:counter"));
        reporterConfig.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("*:excluded"));
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test", (Reporter)reporter, DefaultReporterFilters.metricsFromConfiguration((Configuration)reporterConfig))));
        registry.register((Metric)new TestMeter(), "", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter.getLastAddedMetric()).isEmpty();
        registry.register((Metric)new TestCounter(), "excluded", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter.getLastAddedMetric()).isEmpty();
        registry.register((Metric)new TestCounter(), "foo", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter.getLastAddedMetric()).isNotEmpty();
    }

    @Test
    void testSpanFiltering() {
        String includedGroupName = "foo";
        String excludedSpanName = "excluded";
        NotificationCapturingSpanReporter reporter = new NotificationCapturingSpanReporter();
        Configuration reporterConfig = new Configuration();
        reporterConfig.set(TraceOptions.REPORTER_INCLUDES, Collections.singletonList("foo:*"));
        reporterConfig.set(TraceOptions.REPORTER_EXCLUDES, Collections.singletonList("*:excluded"));
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.emptyList(), Collections.singletonList((TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("test", (Reporter)reporter, DefaultReporterFilters.tracesFromConfiguration((Configuration)reporterConfig))), Collections.emptyList());
        registry.addSpan(Span.builder(this.getClass(), (String)"testSpan"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "bar"));
        Assertions.assertThat(reporter.getLastAddedSpan()).isEmpty();
        registry.addSpan(Span.builder(this.getClass(), (String)"excluded"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "foo"));
        Assertions.assertThat(reporter.getLastAddedSpan()).isEmpty();
        registry.addSpan(Span.builder(this.getClass(), (String)"foo"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "foo"));
        Assertions.assertThat(reporter.getLastAddedSpan()).isNotEmpty();
    }

    @Test
    void testEventFiltering() {
        String includedGroupName = "foo";
        String excludedSpanName = "excluded";
        NotificationCapturingEventReporter reporter = new NotificationCapturingEventReporter();
        Configuration reporterConfig = new Configuration();
        reporterConfig.set(EventOptions.REPORTER_INCLUDES, Collections.singletonList("foo:*"));
        reporterConfig.set(EventOptions.REPORTER_EXCLUDES, Collections.singletonList("*:excluded"));
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList((EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("test", (Reporter)reporter, DefaultReporterFilters.eventsFromConfiguration((Configuration)reporterConfig))));
        registry.addEvent(Event.builder(this.getClass(), (String)"testEvent"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "bar"));
        Assertions.assertThat(reporter.getLastAddedEvent()).isEmpty();
        registry.addEvent(Event.builder(this.getClass(), (String)"excluded"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "foo"));
        Assertions.assertThat(reporter.getLastAddedEvent()).isEmpty();
        registry.addEvent(Event.builder(this.getClass(), (String)"foo"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "foo"));
        Assertions.assertThat(reporter.getLastAddedEvent()).isNotEmpty();
    }

    @Test
    void testSpanAdditionalVariables() {
        NotificationCapturingSpanReporter reporter = new NotificationCapturingSpanReporter();
        Configuration reporterConfig = new Configuration();
        Map<String, String> additionalVariables = Collections.singletonMap("foo", "bar");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.emptyList(), Collections.singletonList((TraceReporterSetup)ReporterSetupBuilder.TRACE_SETUP_BUILDER.forReporter("test", new MetricConfig(), (Reporter)reporter, DefaultReporterFilters.tracesFromConfiguration((Configuration)reporterConfig), additionalVariables)), Collections.emptyList());
        registry.addSpan(Span.builder(this.getClass(), (String)"testEvent"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "testGroup"));
        Optional<Span> lastAddedSpan = reporter.getLastAddedSpan();
        Assertions.assertThat((String)lastAddedSpan.get().getName()).isEqualTo("testEvent");
        Assertions.assertThat((Map)lastAddedSpan.get().getAttributes()).containsExactlyInAnyOrderEntriesOf(additionalVariables);
    }

    @Test
    void testEventAdditionalVariables() {
        NotificationCapturingEventReporter reporter = new NotificationCapturingEventReporter();
        Configuration reporterConfig = new Configuration();
        Map<String, String> additionalVariables = Collections.singletonMap("foo", "bar");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList((EventReporterSetup)ReporterSetupBuilder.EVENT_SETUP_BUILDER.forReporter("test", new MetricConfig(), (Reporter)reporter, DefaultReporterFilters.eventsFromConfiguration((Configuration)reporterConfig), additionalVariables)));
        registry.addEvent(Event.builder(this.getClass(), (String)"testEvent"), (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry, "testGroup"));
        Optional<Event> lastAddedEvent = reporter.getLastAddedEvent();
        Assertions.assertThat((String)lastAddedEvent.get().getName()).isEqualTo("testEvent");
        Assertions.assertThat((Map)lastAddedEvent.get().getAttributes()).containsExactlyInAnyOrderEntriesOf(additionalVariables);
    }

    private static class FailingReporter
    extends TestReporter {
        private FailingReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }
    }

    private static class NotificationCapturingSpanReporter
    extends TestTraceReporter {
        @Nullable
        private Span addedSpan;

        private NotificationCapturingSpanReporter() {
        }

        @Override
        public void notifyOfAddedSpan(Span span) {
            this.addedSpan = span;
        }

        public Optional<Span> getLastAddedSpan() {
            return Optional.ofNullable(this.addedSpan);
        }
    }

    private static class NotificationCapturingEventReporter
    extends TestEventReporter {
        @Nullable
        private Event addedEvent;

        private NotificationCapturingEventReporter() {
        }

        @Override
        public void notifyOfAddedEvent(Event event) {
            this.addedEvent = event;
        }

        public Optional<Event> getLastAddedEvent() {
            return Optional.ofNullable(this.addedEvent);
        }
    }

    private static class NotificationCapturingMetricReporter
    extends TestReporter {
        @Nullable
        private Metric addedMetric;
        @Nullable
        private String addedMetricName;
        @Nullable
        private Metric removedMetric;
        @Nullable
        private String removedMetricName;

        private NotificationCapturingMetricReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            this.addedMetric = metric;
            this.addedMetricName = metricName;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            this.removedMetric = metric;
            this.removedMetricName = metricName;
        }

        public Optional<Metric> getLastAddedMetric() {
            return Optional.ofNullable(this.addedMetric);
        }

        public Optional<String> getLastAddedMetricName() {
            return Optional.ofNullable(this.addedMetricName);
        }

        public Optional<Metric> getLastRemovedMetric() {
            return Optional.ofNullable(this.removedMetric);
        }

        public Optional<String> getLastRemovedMetricName() {
            return Optional.ofNullable(this.removedMetricName);
        }
    }

    private static class ReportCountingReporter
    extends TestReporter
    implements Scheduled {
        private int reportCount = 0;

        private ReportCountingReporter() {
        }

        public void report() {
            ++this.reportCount;
        }

        public int getReportCount() {
            return this.reportCount;
        }

        public void resetCount() {
            this.reportCount = 0;
        }
    }
}

