/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultAllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPool;
import org.apache.flink.runtime.slots.ResourceRequirement;

final class DefaultDeclarativeSlotPoolBuilder {
    private AllocatedSlotPool allocatedSlotPool = new DefaultAllocatedSlotPool();
    private Consumer<? super Collection<ResourceRequirement>> notifyNewResourceRequirements = ignored -> {};
    private Duration idleSlotTimeout = Duration.ofSeconds(20L);
    private Duration rpcTimeout = Duration.ofSeconds(20L);
    private Duration slotRequestMaxInterval = (Duration)JobManagerOptions.SLOT_REQUEST_MAX_INTERVAL.defaultValue();
    private ComponentMainThreadExecutor componentMainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forMainThread();

    DefaultDeclarativeSlotPoolBuilder() {
    }

    public DefaultDeclarativeSlotPoolBuilder setAllocatedSlotPool(AllocatedSlotPool allocatedSlotPool) {
        this.allocatedSlotPool = allocatedSlotPool;
        return this;
    }

    public DefaultDeclarativeSlotPoolBuilder setNotifyNewResourceRequirements(Consumer<? super Collection<ResourceRequirement>> notifyNewResourceRequirements) {
        this.notifyNewResourceRequirements = notifyNewResourceRequirements;
        return this;
    }

    public DefaultDeclarativeSlotPoolBuilder setIdleSlotTimeout(Duration idleSlotTimeout) {
        this.idleSlotTimeout = idleSlotTimeout;
        return this;
    }

    public DefaultDeclarativeSlotPoolBuilder setSlotRequestMaxInterval(Duration slotRequestMaxInterval) {
        this.slotRequestMaxInterval = slotRequestMaxInterval;
        return this;
    }

    public DefaultDeclarativeSlotPoolBuilder setComponentMainThreadExecutor(ComponentMainThreadExecutor componentMainThreadExecutor) {
        this.componentMainThreadExecutor = componentMainThreadExecutor;
        return this;
    }

    public DefaultDeclarativeSlotPool build() {
        return new DefaultDeclarativeSlotPool(new JobID(), this.allocatedSlotPool, this.notifyNewResourceRequirements, this.idleSlotTimeout, this.rpcTimeout, this.slotRequestMaxInterval, this.componentMainThreadExecutor);
    }

    public static DefaultDeclarativeSlotPoolBuilder builder() {
        return new DefaultDeclarativeSlotPoolBuilder();
    }
}

