/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

abstract class AbstractDeclarativeSlotPoolBridgeTest {
    protected static final Duration RPC_TIMEOUT = Duration.ofSeconds(20L);
    protected static final JobID JOB_ID = new JobID();
    protected static final JobMasterId JOB_MASTER_ID = JobMasterId.generate();
    protected final ComponentMainThreadExecutor componentMainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forMainThread();
    @Parameter
    protected RequestSlotMatchingStrategy requestSlotMatchingStrategy;
    @Parameter(value=1)
    protected Duration slotRequestMaxInterval;
    @Parameter(value=2)
    boolean slotBatchAllocatable;

    AbstractDeclarativeSlotPoolBridgeTest() {
    }

    @Parameters(name="requestSlotMatchingStrategy: {0}, slotRequestMaxInterval: {1}, slotBatchAllocatable: {2}")
    private static Collection<Object[]> data() {
        return Arrays.asList({SimpleRequestSlotMatchingStrategy.INSTANCE, Duration.ZERO, false}, {SimpleRequestSlotMatchingStrategy.INSTANCE, Duration.ZERO, true}, {SimpleRequestSlotMatchingStrategy.INSTANCE, Duration.ofMillis(20L), false}, {SimpleRequestSlotMatchingStrategy.INSTANCE, Duration.ofMillis(20L), true}, {PreferredAllocationRequestSlotMatchingStrategy.INSTANCE, Duration.ZERO, false}, {PreferredAllocationRequestSlotMatchingStrategy.INSTANCE, Duration.ZERO, true}, {PreferredAllocationRequestSlotMatchingStrategy.INSTANCE, Duration.ofMillis(20L), false}, {PreferredAllocationRequestSlotMatchingStrategy.INSTANCE, Duration.ofMillis(20L), true});
    }

    @Nonnull
    DeclarativeSlotPoolBridge createDeclarativeSlotPoolBridge(DeclarativeSlotPoolFactory declarativeSlotPoolFactory) {
        return this.createDeclarativeSlotPoolBridge(declarativeSlotPoolFactory, this.componentMainThreadExecutor);
    }

    @Nonnull
    DeclarativeSlotPoolBridge createDeclarativeSlotPoolBridge(DeclarativeSlotPoolFactory declarativeSlotPoolFactory, ComponentMainThreadExecutor componentMainThreadExecutor) {
        return new DeclarativeSlotPoolBridge(JOB_ID, declarativeSlotPoolFactory, (Clock)SystemClock.getInstance(), RPC_TIMEOUT, Duration.ofSeconds(20L), Duration.ofSeconds(20L), this.requestSlotMatchingStrategy, this.slotRequestMaxInterval, this.slotBatchAllocatable, componentMainThreadExecutor);
    }

    static PhysicalSlot createAllocatedSlot(AllocationID allocationID) {
        return new AllocatedSlot(allocationID, (TaskManagerLocation)new LocalTaskManagerLocation(), 0, ResourceProfile.ANY, (TaskManagerGateway)new RpcTaskManagerGateway((TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway(), JobMasterId.generate()));
    }
}

