/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobmaster.event.FsBatchFlushOutputStream;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FsBatchFlushOutputStreamTest {
    @TempDir
    private java.nio.file.Path temporaryFolder;
    private static final int BUFFER_SIZE = 10000;

    FsBatchFlushOutputStreamTest() {
    }

    @Test
    void testBatchFlush() throws IOException {
        int i;
        Path workingDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder).getAbsolutePath());
        Path file = new Path(workingDir, "test-file");
        TestingFsBatchFlushOutputStream outputStream = new TestingFsBatchFlushOutputStream(file.getFileSystem(), file, FileSystem.WriteMode.NO_OVERWRITE, 10000);
        int dataSize = 1000;
        for (i = 0; i < 9; ++i) {
            outputStream.write(new byte[dataSize]);
            Assertions.assertThat((int)outputStream.flushCount).isZero();
        }
        outputStream.write(new byte[dataSize]);
        Assertions.assertThat((int)outputStream.flushCount).isEqualTo(1);
        for (i = 0; i < 9; ++i) {
            outputStream.write(new byte[dataSize]);
            Assertions.assertThat((int)outputStream.flushCount).isEqualTo(1);
        }
        outputStream.write(new byte[dataSize - 1]);
        Assertions.assertThat((int)outputStream.flushCount).isEqualTo(1);
        outputStream.write(new byte[1]);
        Assertions.assertThat((int)outputStream.flushCount).isEqualTo(2);
    }

    @Test
    void testWriteLargerThanBufferSize() throws IOException {
        Path workingDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder).getAbsolutePath());
        Path file = new Path(workingDir, "test-file");
        TestingFsBatchFlushOutputStream outputStream = new TestingFsBatchFlushOutputStream(file.getFileSystem(), file, FileSystem.WriteMode.NO_OVERWRITE, 10000);
        Assertions.assertThat((int)outputStream.flushCount).isZero();
        outputStream.write(new byte[10001]);
        Assertions.assertThat((int)outputStream.flushCount).isEqualTo(1);
    }

    private static class TestingFsBatchFlushOutputStream
    extends FsBatchFlushOutputStream {
        int flushCount = 0;

        TestingFsBatchFlushOutputStream(FileSystem fileSystem, Path filePath, FileSystem.WriteMode overwriteMode, int bufferSize) throws IOException {
            super(fileSystem, filePath, overwriteMode, bufferSize);
        }

        public void flush() throws IOException {
            super.flush();
            ++this.flushCount;
        }
    }
}

