/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.reader.RecordReader;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.types.IntValue;

public class Tasks {
    private static void consumeInputs(int numberOfInputs, AbstractInvokable consumer) throws IOException, InterruptedException {
        for (int i = 0; i < numberOfInputs; ++i) {
            RecordReader reader = new RecordReader((InputGate)consumer.getEnvironment().getInputGate(i), IntValue.class, consumer.getEnvironment().getTaskManagerInfo().getTmpDirectories());
            while (reader.next() != null) {
            }
        }
    }

    public static class InstantiationErrorSender
    extends AbstractInvokable {
        public InstantiationErrorSender(Environment environment) {
            super(environment);
            throw new RuntimeException("Test exception in constructor");
        }

        public void invoke() throws Exception {
        }
    }

    public static class ExceptionReceiver
    extends AbstractInvokable {
        public ExceptionReceiver(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            throw new Exception("Test exception");
        }
    }

    public static class ExceptionSender
    extends AbstractInvokable {
        public ExceptionSender(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            throw new Exception("Test exception");
        }
    }

    public static class AgnosticTertiaryReceiver
    extends AbstractInvokable {
        public AgnosticTertiaryReceiver(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            Tasks.consumeInputs(3, this);
        }
    }

    public static class AgnosticBinaryReceiver
    extends AbstractInvokable {
        public AgnosticBinaryReceiver(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            Tasks.consumeInputs(2, this);
        }
    }

    public static class AgnosticReceiver
    extends AbstractInvokable {
        public AgnosticReceiver(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            Tasks.consumeInputs(1, this);
        }
    }

    public static class Forwarder
    extends AbstractInvokable {
        public Forwarder(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            RecordReader reader = new RecordReader((InputGate)this.getEnvironment().getInputGate(0), IntValue.class, this.getEnvironment().getTaskManagerInfo().getTmpDirectories());
            try (RecordWriter writer = new RecordWriterBuilder().build(this.getEnvironment().getWriter(0));){
                while (true) {
                    IntValue record;
                    if ((record = (IntValue)reader.next()) == null) {
                        return;
                    }
                    writer.emit((IOReadableWritable)record);
                }
            }
        }
    }
}

