/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class JobResourceRequirementsTest {
    private final JobVertexID firstVertexId = new JobVertexID();
    private final JobVertexID secondVertexId = new JobVertexID();

    JobResourceRequirementsTest() {
    }

    @Test
    void testSuccessfulValidation() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 1, 4).setParallelismForJobVertex(this.secondVertexId, 1, 4).build();
        HashMap<JobVertexID, Integer> maxParallelismPerVertex = new HashMap<JobVertexID, Integer>();
        maxParallelismPerVertex.put(this.firstVertexId, 10);
        maxParallelismPerVertex.put(this.secondVertexId, 10);
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, maxParallelismPerVertex);
        Assertions.assertThat((List)validationErrors).isEmpty();
    }

    @Test
    void testValidateVertexIdsNotFoundInJobGraph() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 1, 4).setParallelismForJobVertex(this.secondVertexId, 1, 4).build();
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, Collections.emptyMap());
        Assertions.assertThat((List)validationErrors).hasSize(2);
        for (String validationError : validationErrors) {
            Assertions.assertThat((String)validationError).contains(new CharSequence[]{"was not found in the JobGraph"});
        }
    }

    @Test
    void testValidateUpperBoundHigherThanMaxParallelism() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 1, 10).setParallelismForJobVertex(this.secondVertexId, 1, 5).build();
        HashMap<JobVertexID, Integer> maxParallelismPerVertex = new HashMap<JobVertexID, Integer>();
        maxParallelismPerVertex.put(this.firstVertexId, 5);
        maxParallelismPerVertex.put(this.secondVertexId, 5);
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, maxParallelismPerVertex);
        Assertions.assertThat((List)validationErrors).hasSize(1);
        for (String validationError : validationErrors) {
            Assertions.assertThat((String)validationError).contains(new CharSequence[]{"exceeds its maximum parallelism"});
        }
    }

    @Test
    void testValidateIncompleteRequirements() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 1, 10).build();
        HashMap<JobVertexID, Integer> maxParallelismPerVertex = new HashMap<JobVertexID, Integer>();
        maxParallelismPerVertex.put(this.firstVertexId, 10);
        maxParallelismPerVertex.put(this.secondVertexId, 10);
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, maxParallelismPerVertex);
        Assertions.assertThat((List)validationErrors).hasSize(1);
        for (String validationError : validationErrors) {
            Assertions.assertThat((String)validationError).contains(new CharSequence[]{"request is incomplete"});
        }
    }

    @Test
    void testValidateLowerBoundDoesNotExceedUpperBound() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 10, 9).setParallelismForJobVertex(this.secondVertexId, 10, 10).build();
        HashMap<JobVertexID, Integer> maxParallelismPerVertex = new HashMap<JobVertexID, Integer>();
        maxParallelismPerVertex.put(this.firstVertexId, 10);
        maxParallelismPerVertex.put(this.secondVertexId, 10);
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, maxParallelismPerVertex);
        Assertions.assertThat((List)validationErrors).hasSize(1);
        for (String validationError : validationErrors) {
            Assertions.assertThat((String)validationError).contains(new CharSequence[]{"is higher than the upper bound"});
        }
    }

    @Test
    void testValidateLowerOrUpperBoundIsLowerThanOne() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 0, 10).setParallelismForJobVertex(this.secondVertexId, 1, 0).build();
        HashMap<JobVertexID, Integer> maxParallelismPerVertex = new HashMap<JobVertexID, Integer>();
        maxParallelismPerVertex.put(this.firstVertexId, 10);
        maxParallelismPerVertex.put(this.secondVertexId, 10);
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, maxParallelismPerVertex);
        Assertions.assertThat((List)validationErrors).hasSize(2);
        for (String validationError : validationErrors) {
            Assertions.assertThat((String)validationError).contains(new CharSequence[]{"must be greater than zero"});
        }
    }

    @Test
    void testValidateDefaults() {
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, -1, -1).build();
        HashMap<JobVertexID, Integer> maxParallelismPerVertex = new HashMap<JobVertexID, Integer>();
        maxParallelismPerVertex.put(this.firstVertexId, 10);
        List validationErrors = JobResourceRequirements.validate((JobResourceRequirements)jobResourceRequirements, maxParallelismPerVertex);
        Assertions.assertThat((List)validationErrors).isEmpty();
    }

    @Test
    void testWriteToJobGraphAndReadFromExecutionPlan() throws IOException {
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        JobResourceRequirements jobResourceRequirements = JobResourceRequirements.newBuilder().setParallelismForJobVertex(this.firstVertexId, 10, 9).setParallelismForJobVertex(this.secondVertexId, 10, 10).build();
        JobResourceRequirements.writeToExecutionPlan((ExecutionPlan)jobGraph, (JobResourceRequirements)jobResourceRequirements);
        Assertions.assertThat((Optional)JobResourceRequirements.readFromExecutionPlan((ExecutionPlan)jobGraph)).get().isEqualTo((Object)jobResourceRequirements);
    }

    @Test
    void testReadNonExistentResourceRequirementsFromJobGraph() throws IOException {
        Assertions.assertThat((Optional)JobResourceRequirements.readFromExecutionPlan((ExecutionPlan)JobGraphTestUtils.emptyJobGraph())).isEmpty();
    }
}

