/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfSegmentEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.SubpartitionDiskCacheManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubpartitionDiskCacheManagerTest {
    SubpartitionDiskCacheManagerTest() {
    }

    @Test
    void testAppendBuffer() {
        int bufferBytes = 5;
        SubpartitionDiskCacheManager subpartitionDiskCacheManager = new SubpartitionDiskCacheManager();
        Buffer buffer = BufferBuilderTestUtils.buildSomeBuffer(bufferBytes);
        subpartitionDiskCacheManager.append(buffer);
        List bufferAndIndexes = subpartitionDiskCacheManager.removeAllBuffers();
        Assertions.assertThat((List)bufferAndIndexes).hasSize(1);
        Assertions.assertThat((Object)((Tuple2)bufferAndIndexes.get(0))).isNotNull();
        Assertions.assertThat((int)((Buffer)((Tuple2)bufferAndIndexes.get((int)0)).f0).readableBytes()).isEqualTo(bufferBytes);
    }

    @Test
    void testAppendEndOfSegmentRecord() throws IOException {
        SubpartitionDiskCacheManager subpartitionDiskCacheManager = new SubpartitionDiskCacheManager();
        subpartitionDiskCacheManager.appendEndOfSegmentEvent(EventSerializer.toSerializedEvent((AbstractEvent)EndOfSegmentEvent.INSTANCE));
        List bufferAndIndexes = subpartitionDiskCacheManager.removeAllBuffers();
        Assertions.assertThat((List)bufferAndIndexes).hasSize(1);
        Assertions.assertThat((Object)((Tuple2)bufferAndIndexes.get(0))).isNotNull();
        Buffer buffer = (Buffer)((Tuple2)bufferAndIndexes.get((int)0)).f0;
        Assertions.assertThat((boolean)buffer.isBuffer()).isFalse();
        AbstractEvent event = EventSerializer.fromSerializedEvent((ByteBuffer)buffer.readOnlySlice().getNioBufferReadable(), (ClassLoader)this.getClass().getClassLoader());
        Assertions.assertThat((Object)event).isInstanceOf(EndOfSegmentEvent.class);
    }

    @Test
    void testRelease() {
        SubpartitionDiskCacheManager subpartitionDiskCacheManager = new SubpartitionDiskCacheManager();
        Buffer buffer = BufferBuilderTestUtils.buildSomeBuffer();
        subpartitionDiskCacheManager.append(buffer);
        List bufferAndIndexes = subpartitionDiskCacheManager.removeAllBuffers();
        Assertions.assertThat((List)bufferAndIndexes).hasSize(1);
        Assertions.assertThat((Object)((Buffer)((Tuple2)bufferAndIndexes.get((int)0)).f0)).isEqualTo((Object)buffer);
        Assertions.assertThatNoException().isThrownBy(() -> ((SubpartitionDiskCacheManager)subpartitionDiskCacheManager).release());
    }
}

