/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyServiceProducer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;

public class TestingTieredStorageNettyService
implements TieredStorageNettyService {
    private final BiConsumer<TieredStoragePartitionId, NettyServiceProducer> registerProducerConsumer;
    private final BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<NettyConnectionReader>> registerConsumerFunction;

    private TestingTieredStorageNettyService(BiConsumer<TieredStoragePartitionId, NettyServiceProducer> registerProducerConsumer, BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<NettyConnectionReader>> registerConsumerFunction) {
        this.registerProducerConsumer = registerProducerConsumer;
        this.registerConsumerFunction = registerConsumerFunction;
    }

    public void registerProducer(TieredStoragePartitionId partitionId, NettyServiceProducer serviceProducer) {
        this.registerProducerConsumer.accept(partitionId, serviceProducer);
    }

    public CompletableFuture<NettyConnectionReader> registerConsumer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId) {
        return this.registerConsumerFunction.apply(partitionId, subpartitionId);
    }

    public static class Builder {
        private BiConsumer<TieredStoragePartitionId, NettyServiceProducer> registerProducerConsumer = (partitionId, nettyServiceProducer) -> {};
        private BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<NettyConnectionReader>> registerConsumerFunction = (tieredStoragePartitionId, subpartitionId) -> null;

        public Builder setRegisterProducerConsumer(BiConsumer<TieredStoragePartitionId, NettyServiceProducer> registerProducerConsumer) {
            this.registerProducerConsumer = registerProducerConsumer;
            return this;
        }

        public Builder setRegisterConsumerFunction(BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<NettyConnectionReader>> registerConsumerFunction) {
            this.registerConsumerFunction = registerConsumerFunction;
            return this;
        }

        public TestingTieredStorageNettyService build() {
            return new TestingTieredStorageNettyService(this.registerProducerConsumer, this.registerConsumerFunction);
        }
    }
}

