/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;

public class TestingProducerMergedPartitionFileIndex
extends ProducerMergedPartitionFileIndex {
    private final Consumer<List<ProducerMergedPartitionFileIndex.FlushedBuffer>> addBuffersConsumer;
    private final BiFunction<TieredStorageSubpartitionId, Integer, Optional<ProducerMergedPartitionFileIndex.FixedSizeRegion>> getRegionFunction;
    private final Runnable releaseRunnable;

    private TestingProducerMergedPartitionFileIndex(int numSubpartitions, Path indexFilePath, int regionGroupSizeInBytes, long numRetainedInMemoryRegionsMax, Consumer<List<ProducerMergedPartitionFileIndex.FlushedBuffer>> addBuffersConsumer, BiFunction<TieredStorageSubpartitionId, Integer, Optional<ProducerMergedPartitionFileIndex.FixedSizeRegion>> getRegionFunction, Runnable releaseRunnable) {
        super(numSubpartitions, indexFilePath, regionGroupSizeInBytes, numRetainedInMemoryRegionsMax);
        this.addBuffersConsumer = addBuffersConsumer;
        this.getRegionFunction = getRegionFunction;
        this.releaseRunnable = releaseRunnable;
    }

    void addBuffers(List<ProducerMergedPartitionFileIndex.FlushedBuffer> buffers) {
        this.addBuffersConsumer.accept(buffers);
    }

    Optional<ProducerMergedPartitionFileIndex.FixedSizeRegion> getRegion(TieredStorageSubpartitionId subpartitionId, int bufferIndex) {
        return this.getRegionFunction.apply(subpartitionId, bufferIndex);
    }

    void release() {
        this.releaseRunnable.run();
    }

    public static class Builder {
        private int numSubpartitions = 1;
        private Path indexFilePath = null;
        private int regionGroupSizeInBytes = 256;
        private long numRetainedInMemoryRegionsMax = Long.MAX_VALUE;
        private Consumer<List<ProducerMergedPartitionFileIndex.FlushedBuffer>> addBuffersConsumer = flushedBuffers -> {};
        private BiFunction<TieredStorageSubpartitionId, Integer, Optional<ProducerMergedPartitionFileIndex.FixedSizeRegion>> getRegionFunction = (tieredStorageSubpartitionId, integer) -> Optional.empty();
        private Runnable releaseRunnable = () -> {};

        public Builder setNumSubpartitions(int numSubpartitions) {
            this.numSubpartitions = numSubpartitions;
            return this;
        }

        public Builder setIndexFilePath(Path indexFilePath) {
            this.indexFilePath = indexFilePath;
            return this;
        }

        public Builder setRegionGroupSizeInBytes(int regionGroupSizeInBytes) {
            this.regionGroupSizeInBytes = regionGroupSizeInBytes;
            return this;
        }

        public Builder setNumRetainedInMemoryRegionsMax(long numRetainedInMemoryRegionsMax) {
            this.numRetainedInMemoryRegionsMax = numRetainedInMemoryRegionsMax;
            return this;
        }

        public Builder setAddBuffersConsumer(Consumer<List<ProducerMergedPartitionFileIndex.FlushedBuffer>> addBuffersConsumer) {
            this.addBuffersConsumer = addBuffersConsumer;
            return this;
        }

        public Builder setGetRegionFunction(BiFunction<TieredStorageSubpartitionId, Integer, Optional<ProducerMergedPartitionFileIndex.FixedSizeRegion>> getRegionFunction) {
            this.getRegionFunction = getRegionFunction;
            return this;
        }

        public Builder setReleaseRunnable(Runnable releaseRunnable) {
            this.releaseRunnable = releaseRunnable;
            return this;
        }

        public TestingProducerMergedPartitionFileIndex build() {
            return new TestingProducerMergedPartitionFileIndex(this.numSubpartitions, this.indexFilePath, this.regionGroupSizeInBytes, this.numRetainedInMemoryRegionsMax, this.addBuffersConsumer, this.getRegionFunction, this.releaseRunnable);
        }
    }
}

