/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RecoveredInputChannelTest {
    RecoveredInputChannelTest() {
    }

    @Test
    void testConversionOnlyPossibleAfterConsumed() {
        Assertions.assertThatThrownBy(() -> this.buildChannel().toInputChannel()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRequestPartitionsImpossible() {
        Assertions.assertThatThrownBy(() -> this.buildChannel().requestSubpartitions()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testCheckpointStartImpossible() {
        Assertions.assertThatThrownBy(() -> this.buildChannel().checkpointStarted(new CheckpointBarrier(0L, 0L, CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault())))).isInstanceOf(CheckpointException.class);
    }

    private RecoveredInputChannel buildChannel() {
        try {
            return new RecoveredInputChannel(new SingleInputGateBuilder().build(), 0, new ResultPartitionID(), new ResultSubpartitionIndexSet(0), 0, 0, (Counter)new SimpleCounter(), (Counter)new SimpleCounter(), 10){

                protected InputChannel toInputChannelInternal() {
                    throw new AssertionError((Object)"channel conversion succeeded");
                }
            };
        }
        catch (Exception e) {
            throw new AssertionError("channel creation failed", e);
        }
    }
}

