/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PrioritizedDequeTest {
    PrioritizedDequeTest() {
    }

    @Test
    void testPrioritizeOnAdd() {
        PrioritizedDeque deque = new PrioritizedDeque();
        deque.add((Object)0);
        deque.add((Object)1);
        deque.add((Object)2);
        deque.add((Object)3);
        deque.add((Object)3, true, true);
        Assertions.assertThat((Collection)deque.asUnmodifiableCollection()).containsExactly((Object[])new Integer[]{3, 0, 1, 2});
    }

    @Test
    void testPrioritize() {
        PrioritizedDeque deque = new PrioritizedDeque();
        deque.add((Object)0);
        deque.add((Object)1);
        deque.add((Object)2);
        deque.add((Object)3);
        deque.prioritize((Object)3);
        Assertions.assertThat((Collection)deque.asUnmodifiableCollection()).containsExactly((Object[])new Integer[]{3, 0, 1, 2});
    }

    @Test
    void testGetAndRemove() {
        PrioritizedDeque deque = new PrioritizedDeque();
        deque.add((Object)0);
        deque.add((Object)1);
        deque.add((Object)2);
        deque.add((Object)1);
        deque.add((Object)3);
        Assertions.assertThat((int)((Integer)deque.getAndRemove(v -> v == 1))).isOne();
        Assertions.assertThat((Collection)deque.asUnmodifiableCollection()).containsExactly((Object[])new Integer[]{0, 2, 1, 3});
        Assertions.assertThat((int)((Integer)deque.getAndRemove(v -> v == 1))).isOne();
        Assertions.assertThat((Collection)deque.asUnmodifiableCollection()).containsExactly((Object[])new Integer[]{0, 2, 3});
        try {
            int removed = (Integer)deque.getAndRemove(v -> v == 1);
            Assertions.fail((String)String.format("This should not happen. Item [%s] was removed, but it shouldn't be found", removed));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

