/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class NettyBufferPoolTest {
    private final List<ByteBuf> needReleasing = new ArrayList<ByteBuf>();

    NettyBufferPoolTest() {
    }

    @AfterEach
    void tearDown() {
        try {
            for (ByteBuf buf : this.needReleasing) {
                buf.release();
            }
            for (ByteBuf buf : this.needReleasing) {
                Assertions.assertThat((int)buf.refCnt()).isZero();
            }
        }
        finally {
            this.needReleasing.clear();
        }
    }

    @Test
    void testNoHeapAllocations() {
        NettyBufferPool nettyBufferPool = new NettyBufferPool(1);
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.buffer()).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.buffer(128)).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.buffer(128, 256)).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.ioBuffer()).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.ioBuffer(128)).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.ioBuffer(128, 256)).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.heapBuffer()).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.heapBuffer(128)).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater(nettyBufferPool.heapBuffer(128, 256)).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater((ByteBuf)nettyBufferPool.compositeHeapBuffer()).capacity(1024).isDirect()).isTrue();
        Assertions.assertThat((boolean)this.releaseLater((ByteBuf)nettyBufferPool.compositeHeapBuffer(10)).capacity(1024).isDirect()).isTrue();
        Assertions.assertThat((boolean)nettyBufferPool.isDirectBufferPooled()).isTrue();
    }

    @Test
    void testAllocationsStatistics() throws Exception {
        NettyBufferPool nettyBufferPool = new NettyBufferPool(1);
        int chunkSize = nettyBufferPool.getChunkSize();
        this.releaseLater(nettyBufferPool.directBuffer(chunkSize - 64));
        Assertions.assertThat((Optional)nettyBufferPool.getNumberOfAllocatedBytes()).hasValue((Object)chunkSize);
        this.releaseLater(nettyBufferPool.directBuffer(128));
        Assertions.assertThat((Optional)nettyBufferPool.getNumberOfAllocatedBytes()).hasValue((Object)(2L * (long)chunkSize));
    }

    private ByteBuf releaseLater(ByteBuf buf) {
        this.needReleasing.add(buf);
        return buf;
    }
}

