/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.runner.DispatcherLeaderProcess;

class TestingDispatcherLeaderProcess
implements DispatcherLeaderProcess {
    private final UUID leaderSessionId;
    private final CompletableFuture<DispatcherGateway> dispatcherGatewayFuture;
    private final Consumer<Void> startConsumer;
    private final Supplier<CompletableFuture<Void>> closeAsyncSupplier;
    private final CompletableFuture<String> confirmLeaderSessionFuture;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private CompletableFuture<Void> terminationFuture = null;

    private TestingDispatcherLeaderProcess(UUID leaderSessionId, CompletableFuture<DispatcherGateway> dispatcherGatewayFuture, Consumer<Void> startConsumer, Supplier<CompletableFuture<Void>> closeAsyncSupplier, CompletableFuture<String> confirmLeaderSessionFuture, CompletableFuture<ApplicationStatus> shutDownFuture) {
        this.leaderSessionId = leaderSessionId;
        this.dispatcherGatewayFuture = dispatcherGatewayFuture;
        this.startConsumer = startConsumer;
        this.closeAsyncSupplier = closeAsyncSupplier;
        this.confirmLeaderSessionFuture = confirmLeaderSessionFuture;
        this.shutDownFuture = shutDownFuture;
    }

    public void start() {
        this.startConsumer.accept(null);
    }

    public UUID getLeaderSessionId() {
        return this.leaderSessionId;
    }

    public CompletableFuture<DispatcherGateway> getDispatcherGateway() {
        return this.dispatcherGatewayFuture;
    }

    public CompletableFuture<String> getLeaderAddressFuture() {
        return this.confirmLeaderSessionFuture;
    }

    public CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.terminationFuture == null) {
            this.terminationFuture = this.closeAsyncSupplier.get();
        }
        return this.terminationFuture;
    }

    public static Builder newBuilder(UUID leaderSessionId) {
        return new Builder(leaderSessionId);
    }

    public static class Builder {
        private final UUID leaderSessionId;
        private CompletableFuture<DispatcherGateway> dispatcherGatewayFuture = new CompletableFuture();
        private Consumer<Void> startConsumer = ignored -> {};
        private Supplier<CompletableFuture<Void>> closeAsyncSupplier = () -> CompletableFuture.completedFuture(null);
        private CompletableFuture<String> confirmLeaderSessionFuture = CompletableFuture.completedFuture("Unknown address");
        private CompletableFuture<ApplicationStatus> shutDownFuture = new CompletableFuture();

        private Builder(UUID leaderSessionId) {
            this.leaderSessionId = leaderSessionId;
        }

        public Builder setDispatcherGatewayFuture(CompletableFuture<DispatcherGateway> dispatcherGatewayFuture) {
            this.dispatcherGatewayFuture = dispatcherGatewayFuture;
            return this;
        }

        public Builder setStartConsumer(Consumer<Void> startConsumer) {
            this.startConsumer = startConsumer;
            return this;
        }

        public Builder setCloseAsyncSupplier(Supplier<CompletableFuture<Void>> closeAsyncSupplier) {
            this.closeAsyncSupplier = closeAsyncSupplier;
            return this;
        }

        public Builder setConfirmLeaderSessionFuture(CompletableFuture<String> confirmLeaderSessionFuture) {
            this.confirmLeaderSessionFuture = confirmLeaderSessionFuture;
            return this;
        }

        public Builder setShutDownFuture(CompletableFuture<ApplicationStatus> shutDownFuture) {
            this.shutDownFuture = shutDownFuture;
            return this;
        }

        public TestingDispatcherLeaderProcess build() {
            return new TestingDispatcherLeaderProcess(this.leaderSessionId, this.dispatcherGatewayFuture, this.startConsumer, this.closeAsyncSupplier, this.confirmLeaderSessionFuture, this.shutDownFuture);
        }
    }
}

