/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.util.concurrent.FutureUtils;

class TestingDispatcherGatewayService
implements AbstractDispatcherLeaderProcess.DispatcherGatewayService {
    private final Function<JobID, CompletableFuture<Void>> onRemovedExecutionPlanFunction;
    private final DispatcherGateway dispatcherGateway;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private final CompletableFuture<Void> terminationFuture;
    private final boolean completeTerminationFutureOnClose;

    private TestingDispatcherGatewayService(CompletableFuture<Void> terminationFuture, Function<JobID, CompletableFuture<Void>> onRemovedExecutionPlanFunction, DispatcherGateway dispatcherGateway, CompletableFuture<ApplicationStatus> shutDownFuture, boolean completeTerminationFutureOnClose) {
        this.terminationFuture = terminationFuture;
        this.onRemovedExecutionPlanFunction = onRemovedExecutionPlanFunction;
        this.dispatcherGateway = dispatcherGateway;
        this.shutDownFuture = shutDownFuture;
        this.completeTerminationFutureOnClose = completeTerminationFutureOnClose;
    }

    public DispatcherGateway getGateway() {
        return this.dispatcherGateway;
    }

    public CompletableFuture<Void> onRemovedExecutionPlan(JobID jobId) {
        return this.onRemovedExecutionPlanFunction.apply(jobId);
    }

    public CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.completeTerminationFutureOnClose) {
            this.terminationFuture.complete(null);
        }
        return this.terminationFuture;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private CompletableFuture<Void> terminationFuture = new CompletableFuture();
        private Function<JobID, CompletableFuture<Void>> onRemovedExecutionPlanFunction = ignored -> FutureUtils.completedVoidFuture();
        private DispatcherGateway dispatcherGateway = TestingDispatcherGateway.newBuilder().build();
        private CompletableFuture<ApplicationStatus> shutDownFuture = new CompletableFuture();
        private boolean completeTerminationFutureOnClose = true;

        private Builder() {
        }

        public Builder setTerminationFuture(CompletableFuture<Void> terminationFuture) {
            this.terminationFuture = terminationFuture;
            return this;
        }

        public Builder setDispatcherGateway(DispatcherGateway dispatcherGateway) {
            this.dispatcherGateway = dispatcherGateway;
            return this;
        }

        public Builder setOnRemovedJobGraphFunction(Function<JobID, CompletableFuture<Void>> onRemovedExecutionPlanFunction) {
            this.onRemovedExecutionPlanFunction = onRemovedExecutionPlanFunction;
            return this;
        }

        public Builder setShutDownFuture(CompletableFuture<ApplicationStatus> shutDownFuture) {
            this.shutDownFuture = shutDownFuture;
            return this;
        }

        public Builder withManualTerminationFutureCompletion() {
            this.completeTerminationFutureOnClose = false;
            return this;
        }

        public TestingDispatcherGatewayService build() {
            return new TestingDispatcherGatewayService(this.terminationFuture, this.onRemovedExecutionPlanFunction, this.dispatcherGateway, this.shutDownFuture, this.completeTerminationFutureOnClose);
        }
    }
}

