/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.junit.jupiter.api.Test;

class ResourceProfileTest {
    private static final MemorySize TOO_LARGE_MEMORY = ResourceProfile.MAX_MEMORY_SIZE_TO_LOG.add(MemorySize.ofMebiBytes((long)10L));
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    ResourceProfileTest() {
    }

    @Test
    void testAllFieldsNoLessThanProfile() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile rp4 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).build();
        Assertions.assertThat((boolean)rp1.allFieldsNoLessThan(rp2)).isFalse();
        Assertions.assertThat((boolean)rp2.allFieldsNoLessThan(rp1)).isTrue();
        Assertions.assertThat((boolean)rp1.allFieldsNoLessThan(rp3)).isFalse();
        Assertions.assertThat((boolean)rp3.allFieldsNoLessThan(rp1)).isTrue();
        Assertions.assertThat((boolean)rp2.allFieldsNoLessThan(rp3)).isFalse();
        Assertions.assertThat((boolean)rp3.allFieldsNoLessThan(rp2)).isFalse();
        Assertions.assertThat((boolean)rp4.allFieldsNoLessThan(rp1)).isTrue();
        Assertions.assertThat((boolean)rp4.allFieldsNoLessThan(rp2)).isTrue();
        Assertions.assertThat((boolean)rp4.allFieldsNoLessThan(rp3)).isTrue();
        Assertions.assertThat((boolean)rp4.allFieldsNoLessThan(rp4)).isTrue();
        ResourceProfile rp5 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        Assertions.assertThat((boolean)rp4.allFieldsNoLessThan(rp5)).isFalse();
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        Assertions.assertThat((boolean)rp1.allFieldsNoLessThan(ResourceProfile.fromResourceSpec((ResourceSpec)rs1))).isFalse();
        Assertions.assertThat((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs1).allFieldsNoLessThan(ResourceProfile.fromResourceSpec((ResourceSpec)rs2))).isTrue();
        Assertions.assertThat((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs2).allFieldsNoLessThan(ResourceProfile.fromResourceSpec((ResourceSpec)rs1))).isFalse();
    }

    @Test
    void testUnknownNoLessThanUnknown() {
        Assertions.assertThat((boolean)ResourceProfile.UNKNOWN.allFieldsNoLessThan(ResourceProfile.UNKNOWN)).isTrue();
    }

    @Test
    void testMatchRequirement() {
        ResourceProfile resource1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile resource2 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        ResourceProfile requirement1 = ResourceProfile.UNKNOWN;
        ResourceProfile requirement2 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile requirement3 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((boolean)resource1.isMatching(requirement1)).isTrue();
        Assertions.assertThat((boolean)resource1.isMatching(requirement2)).isTrue();
        Assertions.assertThat((boolean)resource1.isMatching(requirement3)).isFalse();
        Assertions.assertThat((boolean)resource2.isMatching(requirement1)).isTrue();
        Assertions.assertThat((boolean)resource2.isMatching(requirement2)).isFalse();
        Assertions.assertThat((boolean)resource2.isMatching(requirement3)).isTrue();
    }

    @Test
    void testEquals() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assertions.assertThat((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs2)).isEqualTo((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs1));
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        Assertions.assertThat((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs4)).isNotEqualTo((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs3));
        ResourceSpec rs5 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        MemorySize networkMemory = MemorySize.ofMebiBytes((long)100L);
        Assertions.assertThat((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs5, (MemorySize)networkMemory)).isEqualTo((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (MemorySize)networkMemory));
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp4 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp5 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(110).setNetworkMemoryMB(100).build();
        ResourceProfile rp6 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(110).setNetworkMemoryMB(100).build();
        ResourceProfile rp7 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(110).build();
        ResourceProfile rp8 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        Assertions.assertThat((Object)rp2).isNotEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp3).isNotEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp4).isNotEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp5).isNotEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp6).isNotEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp7).isNotEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp8).isEqualTo((Object)rp1);
    }

    @Test
    void testGet() {
        ResourceSpec rs = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.6)).build();
        ResourceProfile rp = ResourceProfile.fromResourceSpec((ResourceSpec)rs, (MemorySize)MemorySize.ofMebiBytes((long)50L));
        Assertions.assertThat((Comparable)rp.getCpuCores()).isEqualTo((Object)new CPUResource(1.0));
        Assertions.assertThat((int)rp.getTotalMemory().getMebiBytes()).isEqualTo(150);
        Assertions.assertThat((int)rp.getOperatorsMemory().getMebiBytes()).isEqualTo(100);
        Assertions.assertThat((Comparable)((ExternalResource)rp.getExtendedResources().get(EXTERNAL_RESOURCE_NAME))).isEqualTo((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.6));
    }

    @Test
    void testMerge() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        ResourceProfile rp1MergeRp1 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).build();
        ResourceProfile rp1MergeRp2 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        ResourceProfile rp2MergeRp2 = ResourceProfile.newBuilder().setCpuCores(4.0).setTaskHeapMemoryMB(400).setTaskOffHeapMemoryMB(400).setManagedMemoryMB(400).setNetworkMemoryMB(400).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 4.0)).build();
        Assertions.assertThat((Object)rp1.merge(rp1)).isEqualTo((Object)rp1MergeRp1);
        Assertions.assertThat((Object)rp1.merge(rp2)).isEqualTo((Object)rp1MergeRp2);
        Assertions.assertThat((Object)rp2.merge(rp1)).isEqualTo((Object)rp1MergeRp2);
        Assertions.assertThat((Object)rp2.merge(rp2)).isEqualTo((Object)rp2MergeRp2);
        Assertions.assertThat((Object)rp1.merge(ResourceProfile.UNKNOWN)).isEqualTo((Object)ResourceProfile.UNKNOWN);
        Assertions.assertThat((Object)ResourceProfile.UNKNOWN.merge(rp1)).isEqualTo((Object)ResourceProfile.UNKNOWN);
        Assertions.assertThat((Object)ResourceProfile.UNKNOWN.merge(ResourceProfile.UNKNOWN)).isEqualTo((Object)ResourceProfile.UNKNOWN);
        Assertions.assertThat((Object)rp1.merge(ResourceProfile.ANY)).isEqualTo((Object)ResourceProfile.ANY);
        Assertions.assertThat((Object)ResourceProfile.ANY.merge(rp1)).isEqualTo((Object)ResourceProfile.ANY);
        Assertions.assertThat((Object)ResourceProfile.ANY.merge(ResourceProfile.ANY)).isEqualTo((Object)ResourceProfile.ANY);
    }

    @Test
    void testMergeWithOverflow() {
        CPUResource largeDouble = new CPUResource(Double.MAX_VALUE);
        MemorySize largeMemory = MemorySize.MAX_VALUE.subtract(MemorySize.parse((String)"100m"));
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(largeDouble).setTaskHeapMemory(largeMemory).setTaskOffHeapMemory(largeMemory).setManagedMemory(largeMemory).setNetworkMemory(largeMemory).build();
        ArrayList<ArithmeticException> exceptions = new ArrayList<ArithmeticException>();
        try {
            rp2.merge(rp2);
        }
        catch (ArithmeticException e) {
            exceptions.add(e);
        }
        try {
            rp2.merge(rp1);
        }
        catch (ArithmeticException e) {
            exceptions.add(e);
        }
        try {
            rp1.merge(rp2);
        }
        catch (ArithmeticException e) {
            exceptions.add(e);
        }
        Assertions.assertThat(exceptions).hasSize(3);
    }

    @Test
    void testSubtract() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).build();
        Assertions.assertThat((Object)rp3.subtract(rp2)).isEqualTo((Object)rp1);
        Assertions.assertThat((Object)rp2.subtract(rp1)).isEqualTo((Object)rp1);
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IllegalArgumentException.class).as("The subtract should failed due to trying to subtract a larger resource", new Object[0])).isThrownBy(() -> rp1.subtract(rp2));
        Assertions.assertThat((Object)ResourceProfile.ANY.subtract(rp3)).isEqualTo((Object)ResourceProfile.ANY);
        Assertions.assertThat((Object)ResourceProfile.ANY.subtract(ResourceProfile.ANY)).isEqualTo((Object)ResourceProfile.ANY);
        Assertions.assertThat((Object)rp3.subtract(ResourceProfile.ANY)).isEqualTo((Object)ResourceProfile.ANY);
        Assertions.assertThat((Object)ResourceProfile.UNKNOWN.subtract(rp3)).isEqualTo((Object)ResourceProfile.UNKNOWN);
        Assertions.assertThat((Object)rp3.subtract(ResourceProfile.UNKNOWN)).isEqualTo((Object)ResourceProfile.UNKNOWN);
        Assertions.assertThat((Object)ResourceProfile.UNKNOWN.subtract(ResourceProfile.UNKNOWN)).isEqualTo((Object)ResourceProfile.UNKNOWN);
    }

    @Test
    void testSubtractWithInfValues() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(Double.MAX_VALUE).setTaskHeapMemoryMB(Integer.MAX_VALUE).setTaskOffHeapMemoryMB(Integer.MAX_VALUE).setManagedMemoryMB(Integer.MAX_VALUE).setNetworkMemoryMB(Integer.MAX_VALUE).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 4.0)).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).build();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> rp2.subtract(rp1));
    }

    @Test
    void testMultiply() {
        ResourceProfile rp1;
        int by = 3;
        ResourceProfile rp2 = rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        for (int i = 1; i < 3; ++i) {
            rp2 = rp2.merge(rp1);
        }
        Assertions.assertThat((Object)rp1.multiply(3)).isEqualTo((Object)rp2);
    }

    @Test
    void testMultiplyZero() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((Object)rp1.multiply(0)).isEqualTo((Object)ResourceProfile.ZERO);
    }

    @Test
    public void testMultiplyNegative() {
        ResourceProfile rp = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> rp.multiply(-2));
    }

    @Test
    void testFromSpecWithSerializationCopy() throws Exception {
        ResourceSpec copiedSpec = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        ResourceProfile profile = ResourceProfile.fromResourceSpec((ResourceSpec)copiedSpec);
        Assertions.assertThat((Object)profile).isEqualTo((Object)ResourceProfile.fromResourceSpec((ResourceSpec)ResourceSpec.UNKNOWN));
    }

    @Test
    void testSingletonPropertyOfUnknown() throws Exception {
        ResourceProfile copiedProfile = (ResourceProfile)CommonTestUtils.createCopySerializable((Serializable)ResourceProfile.UNKNOWN);
        Assertions.assertThat((Object)copiedProfile).isSameAs((Object)ResourceProfile.UNKNOWN);
    }

    @Test
    void testSingletonPropertyOfAny() throws Exception {
        ResourceProfile copiedProfile = (ResourceProfile)CommonTestUtils.createCopySerializable((Serializable)ResourceProfile.ANY);
        Assertions.assertThat((Object)copiedProfile).isSameAs((Object)ResourceProfile.ANY);
    }

    @Test
    void doesNotIncludeCPUAndMemoryInToStringIfTheyAreTooLarge() {
        double tooLargeCpuCount = ResourceProfile.MAX_CPU_CORE_NUMBER_TO_LOG.doubleValue() + 1.0;
        ResourceProfile resourceProfile = ResourceProfileTest.createResourceProfile(tooLargeCpuCount, TOO_LARGE_MEMORY);
        ((AbstractStringAssert)Assertions.assertThat((String)resourceProfile.toString()).doesNotContain(new CharSequence[]{"cpuCores="})).doesNotContain(new CharSequence[]{"taskHeapMemory="});
    }

    @Test
    void includesCPUAndMemoryInToStringIfTheyAreBelowThreshold() {
        ResourceProfile resourceProfile = ResourceProfileTest.createResourceProfile(1.0, MemorySize.ofMebiBytes((long)4L));
        ((AbstractStringAssert)Assertions.assertThat((String)resourceProfile.toString()).contains(new CharSequence[]{"cpuCores="})).contains(new CharSequence[]{"taskHeapMemory="});
    }

    @Test
    void testZeroExtendedResourceFromConstructor() {
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.0)).build();
        Assertions.assertThat((Map)resourceProfile.getExtendedResources()).isEmpty();
    }

    @Test
    void testZeroExtendedResourceFromSubtract() {
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((Map)resourceProfile.subtract(resourceProfile).getExtendedResources()).isEmpty();
    }

    private static ResourceProfile createResourceProfile(double cpu, MemorySize taskHeapMemory) {
        return ResourceProfile.newBuilder().setCpuCores(cpu).setTaskHeapMemory(taskHeapMemory).build();
    }
}

