/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.client.SerializedJobExecutionResult;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializedJobExecutionResultTest {
    SerializedJobExecutionResultTest() {
    }

    @Test
    void testSerialization() throws Exception {
        ClassLoader classloader = this.getClass().getClassLoader();
        JobID origJobId = new JobID();
        long origTime = 65927436589267L;
        HashMap<String, SerializedValue> origMap = new HashMap<String, SerializedValue>();
        origMap.put("name1", new SerializedValue((Object)OptionalFailure.of((Object)723L)));
        origMap.put("name2", new SerializedValue((Object)OptionalFailure.of((Object)"peter")));
        origMap.put("name3", new SerializedValue((Object)OptionalFailure.ofFailure((Throwable)new ExpectedTestException())));
        SerializedJobExecutionResult result = new SerializedJobExecutionResult(origJobId, origTime, origMap);
        SerializedJobExecutionResult cloned = (SerializedJobExecutionResult)CommonTestUtils.createCopySerializable((Serializable)result);
        Assertions.assertThat((Comparable)cloned.getJobId()).isEqualTo((Object)origJobId);
        Assertions.assertThat((long)cloned.getNetRuntime()).isEqualTo(origTime);
        Assertions.assertThat((long)cloned.getNetRuntime(TimeUnit.MILLISECONDS)).isEqualTo(origTime);
        Assertions.assertThat((Map)cloned.getSerializedAccumulatorResults()).isEqualTo(origMap);
        JobExecutionResult jResult = result.toJobExecutionResult(classloader);
        JobExecutionResult jResultCopied = result.toJobExecutionResult(classloader);
        Assertions.assertThat((Comparable)jResult.getJobID()).isEqualTo((Object)origJobId);
        Assertions.assertThat((Comparable)jResultCopied.getJobID()).isEqualTo((Object)origJobId);
        Assertions.assertThat((long)jResult.getNetRuntime()).isEqualTo(origTime);
        Assertions.assertThat((long)jResult.getNetRuntime(TimeUnit.MILLISECONDS)).isEqualTo(origTime);
        Assertions.assertThat((long)jResultCopied.getNetRuntime()).isEqualTo(origTime);
        Assertions.assertThat((long)jResultCopied.getNetRuntime(TimeUnit.MILLISECONDS)).isEqualTo(origTime);
        for (Map.Entry entry : origMap.entrySet()) {
            String name = (String)entry.getKey();
            OptionalFailure value = (OptionalFailure)((SerializedValue)entry.getValue()).deserializeValue(classloader);
            if (value.isFailure()) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> jResult.getAccumulatorResult(name)).isInstanceOf(FlinkRuntimeException.class)).hasCauseInstanceOf(ExpectedTestException.class);
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> jResultCopied.getAccumulatorResult(name)).isInstanceOf(FlinkRuntimeException.class)).hasCauseInstanceOf(ExpectedTestException.class);
                continue;
            }
            Assertions.assertThat((Object)jResult.getAccumulatorResult(name)).isEqualTo(value.get());
            Assertions.assertThat((Object)jResultCopied.getAccumulatorResult(name)).isEqualTo(value.get());
        }
    }

    @Test
    void testSerializationWithNullValues() throws Exception {
        SerializedJobExecutionResult result = new SerializedJobExecutionResult(null, 0L, null);
        SerializedJobExecutionResult cloned = (SerializedJobExecutionResult)CommonTestUtils.createCopySerializable((Serializable)result);
        Assertions.assertThat((Comparable)cloned.getJobId()).isNull();
        Assertions.assertThat((long)cloned.getNetRuntime()).isZero();
        Assertions.assertThat((Map)cloned.getSerializedAccumulatorResults()).isNull();
        JobExecutionResult jResult = result.toJobExecutionResult(this.getClass().getClassLoader());
        Assertions.assertThat((Comparable)jResult.getJobID()).isNull();
        Assertions.assertThat((Map)jResult.getAllAccumulatorResults()).isEmpty();
    }
}

