/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.RecoveryClaimMode;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.PerJobCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.TestingCompletedCheckpointStore;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PerJobCheckpointRecoveryTest {
    PerJobCheckpointRecoveryTest() {
    }

    @Test
    void testFactoryWithoutCheckpointStoreRecovery() throws Exception {
        TestingCompletedCheckpointStore store = TestingCompletedCheckpointStore.createStoreWithShutdownCheckAndNoCompletedCheckpoints(new CompletableFuture<JobStatus>());
        CheckpointRecoveryFactory factory = PerJobCheckpointRecoveryFactory.withoutCheckpointStoreRecovery(maxCheckpoints -> store);
        JobID firstJobId = new JobID();
        Assertions.assertThat((Object)factory.createRecoveredCompletedCheckpointStore(firstJobId, 1, SharedStateRegistry.DEFAULT_FACTORY, Executors.directExecutor(), RecoveryClaimMode.DEFAULT)).isSameAs((Object)store);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> factory.createRecoveredCompletedCheckpointStore(firstJobId, 1, SharedStateRegistry.DEFAULT_FACTORY, Executors.directExecutor(), RecoveryClaimMode.DEFAULT));
        JobID secondJobId = new JobID();
        Assertions.assertThat((Object)factory.createRecoveredCompletedCheckpointStore(secondJobId, 1, SharedStateRegistry.DEFAULT_FACTORY, Executors.directExecutor(), RecoveryClaimMode.DEFAULT)).isSameAs((Object)store);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> factory.createRecoveredCompletedCheckpointStore(secondJobId, 1, SharedStateRegistry.DEFAULT_FACTORY, Executors.directExecutor(), RecoveryClaimMode.DEFAULT));
    }
}

