/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.TestingBlobHelpers;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobServerDeleteTest {
    private final Random rnd = new Random();
    @TempDir
    private Path tempDir;

    BlobServerDeleteTest() {
    }

    @Test
    void testDeleteTransient1() throws IOException {
        this.testDeleteBlob(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeleteTransient2() throws IOException {
        this.testDeleteBlob(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeleteTransient3() throws IOException {
        this.testDeleteBlob(null, null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeleteTransient4() throws IOException {
        this.testDeleteBlob(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeleteTransient5() throws IOException {
        JobID jobId = new JobID();
        this.testDeleteBlob(jobId, jobId, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeletePermanent() throws IOException {
        this.testDeleteBlob(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testDeleteBlob(@Nullable JobID jobId1, @Nullable JobID jobId2, BlobKey.BlobType blobType) throws IOException {
        try (BlobServer server = TestingBlobUtils.createServer(this.tempDir);){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            BlobKey key1 = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            Assertions.assertThat((Comparable)key1).isNotNull();
            BlobKey key2a = BlobServerPutTest.put((BlobService)server, jobId2, data, blobType);
            Assertions.assertThat((Comparable)key2a).isNotNull();
            BlobKeyTest.verifyKeyDifferentHashEquals(key1, key2a);
            BlobKey key2b = BlobServerPutTest.put((BlobService)server, jobId2, data2, blobType);
            Assertions.assertThat((Comparable)key2b).isNotNull();
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete(server, jobId1, key1, blobType)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key1);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete(server, jobId2, key2a, blobType)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, key2a);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete(server, jobId2, key2b, blobType)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, key2b);
        }
    }

    @Test
    void testDeleteTransientAlreadyDeletedNoJob() throws IOException {
        this.testDeleteBlobAlreadyDeleted(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeleteTransientAlreadyDeletedForJob() throws IOException {
        this.testDeleteBlobAlreadyDeleted(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testDeletePermanentAlreadyDeletedForJob() throws IOException {
        this.testDeleteBlobAlreadyDeleted(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testDeleteBlobAlreadyDeleted(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        try (BlobServer server = TestingBlobUtils.createServer(this.tempDir);){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            Assertions.assertThat((Comparable)key).isNotNull();
            File blobFile = server.getStorageLocation(jobId, key);
            Assertions.assertThat((boolean)blobFile.delete()).isTrue();
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete(server, jobId, key, blobType)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId, key);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete(server, jobId, key, blobType)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId, key);
        }
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testDeleteTransientFailsNoJob() throws IOException {
        this.testDeleteBlobFails(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testDeleteTransientFailsForJob() throws IOException {
        this.testDeleteBlobFails(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testDeletePermanentFailsForJob() throws IOException {
        this.testDeleteBlobFails(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteBlobFails(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("setWritable doesn't work on Windows", new Object[0])).isFalse();
        File blobFile = null;
        File directory = null;
        try (BlobServer server = TestingBlobUtils.createServer(this.tempDir);){
            server.start();
            try {
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
                Assertions.assertThat((Comparable)key).isNotNull();
                blobFile = server.getStorageLocation(jobId, key);
                directory = blobFile.getParentFile();
                Assertions.assertThat((boolean)blobFile.setWritable(false, false)).isTrue();
                Assertions.assertThat((boolean)directory.setWritable(false, false)).isTrue();
                Assertions.assertThat((boolean)BlobServerDeleteTest.delete(server, jobId, key, blobType)).isFalse();
                BlobServerPutTest.verifyContents((BlobService)server, jobId, key, data);
            }
            finally {
                if (blobFile != null && directory != null) {
                    blobFile.setWritable(true, false);
                    directory.setWritable(true, false);
                }
            }
        }
    }

    @Test
    void testJobCleanup() throws IOException {
        this.testJobCleanup(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testJobCleanupHa() throws IOException {
        this.testJobCleanup(BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testJobCleanup(BlobKey.BlobType blobType) throws IOException {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try (BlobServer server = TestingBlobUtils.createServer(this.tempDir);){
            server.start();
            byte[] data = new byte[128];
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            BlobKey key1a = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            BlobKey key2 = BlobServerPutTest.put((BlobService)server, jobId2, data, blobType);
            Assertions.assertThat((byte[])key1a.getHash()).isEqualTo((Object)key2.getHash());
            BlobKey key1b = BlobServerPutTest.put((BlobService)server, jobId1, data2, blobType);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            TestingBlobHelpers.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2, data);
            TestingBlobHelpers.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            server.globalCleanupAsync(jobId1, (Executor)executorService).join();
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key1a);
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key1b);
            TestingBlobHelpers.checkFileCountForJob(0, jobId1, (PermanentBlobService)server);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2, data);
            TestingBlobHelpers.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            server.globalCleanupAsync(jobId2, (Executor)executorService).join();
            TestingBlobHelpers.checkFileCountForJob(0, jobId1, (PermanentBlobService)server);
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, key2);
            TestingBlobHelpers.checkFileCountForJob(0, jobId2, (PermanentBlobService)server);
            server.globalCleanupAsync(jobId2, (Executor)executorService).join();
        }
        finally {
            Assertions.assertThat(executorService.shutdownNow()).isEmpty();
        }
    }

    @Test
    void testConcurrentDeleteOperationsNoJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(null);
    }

    @Test
    void testConcurrentDeleteOperationsForJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentDeleteOperations(@Nullable JobID jobId) throws IOException, InterruptedException, ExecutionException {
        int concurrentDeleteOperations = 3;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>(3);
        byte[] data = new byte[]{1, 2, 3};
        try (BlobServer server = TestingBlobUtils.createServer(this.tempDir);){
            server.start();
            TransientBlobKey blobKey = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assertions.assertThat((File)server.getStorageLocation(jobId, (BlobKey)blobKey)).exists();
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<Void> deleteFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId, blobKey)).isTrue();
                        Assertions.assertThat((File)server.getStorageLocation(jobId, (BlobKey)blobKey)).doesNotExist();
                        return null;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not delete the given blob key " + blobKey + "."));
                    }
                }, executor);
                deleteFutures.add(deleteFuture);
            }
            FutureUtils.ConjunctFuture waitFuture = FutureUtils.waitForAll(deleteFutures);
            waitFuture.get();
            Assertions.assertThat((File)server.getStorageLocation(jobId, (BlobKey)blobKey)).doesNotExist();
        }
        finally {
            executor.shutdownNow();
        }
    }

    static boolean delete(BlobService service, @Nullable JobID jobId, TransientBlobKey key) {
        if (jobId == null) {
            return service.getTransientBlobService().deleteFromCache(key);
        }
        return service.getTransientBlobService().deleteFromCache(jobId, key);
    }

    private static boolean delete(BlobServer blobServer, @Nullable JobID jobId, BlobKey key, BlobKey.BlobType blobType) {
        Preconditions.checkNotNull((Object)blobServer);
        Preconditions.checkNotNull((Object)key);
        if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
            Preconditions.checkNotNull((Object)jobId);
            Assertions.assertThat((Comparable)key).isInstanceOf(PermanentBlobKey.class);
            return blobServer.deletePermanent(jobId, (PermanentBlobKey)key);
        }
        Assertions.assertThat((Comparable)key).isInstanceOf(TransientBlobKey.class);
        return BlobServerDeleteTest.delete((BlobService)blobServer, jobId, (TransientBlobKey)key);
    }
}

