/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TestingBlobHelpers;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobServerCorruptionTest {
    @TempDir
    private Path tempDir;

    BlobServerCorruptionTest() {
    }

    @Test
    void testGetFailsFromCorruptFile() throws IOException {
        Configuration config = new Configuration();
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)TempDirUtils.newFolder((Path)this.tempDir).getAbsolutePath());
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.tempDir).getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            TestingBlobHelpers.testGetFailsFromCorruptFile(config, (BlobStore)blobStoreService, TempDirUtils.newFolder((Path)this.tempDir));
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.cleanupAllData();
                blobStoreService.close();
            }
        }
    }
}

