/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.AbruptStageTerminationException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.IOOperationIncompleteException;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.IOResult$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001U4QAC\u0006\u0003#]A\u0001b\r\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\")A\t\u0001C\u0001\u000b\"9!\n\u0001b\u0001\n\u0013Y\u0005BB(\u0001A\u0003%A\nC\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003S\u0001\u0011E3\u000bC\u0003X\u0001\u0011\u0005\u0003\fC\u0003b\u0001\u0011\u0005#MA\tJ]B,Ho\u0015;sK\u0006l7k\\;sG\u0016T!\u0001D\u0007\u0002\u0005%|'B\u0001\b\u0010\u0003\u0011IW\u000e\u001d7\u000b\u0005A\t\u0012AB:ue\u0016\fWN\u0003\u0002\u0013'\u0005)\u0001/Z6l_*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h'\t\u0001\u0001\u0004\u0005\u0003\u001a9yAS\"\u0001\u000e\u000b\u0005my\u0011!B:uC\u001e,\u0017BA\u000f\u001b\u0005}9%/\u00199i'R\fw-Z,ji\"l\u0015\r^3sS\u0006d\u0017N_3e-\u0006dW/\u001a\t\u0004?\u0001\u0012S\"A\b\n\u0005\u0005z!aC*pkJ\u001cWm\u00155ba\u0016\u0004\"a\t\u0014\u000e\u0003\u0011R!!J\t\u0002\tU$\u0018\u000e\\\u0005\u0003O\u0011\u0012!BQ=uKN#(/\u001b8h!\rIc\u0006M\u0007\u0002U)\u00111\u0006L\u0001\u000bG>t7-\u001e:sK:$(\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=R#A\u0002$viV\u0014X\r\u0005\u0002 c%\u0011!g\u0004\u0002\t\u0013>\u0013Vm];mi\u00069a-Y2u_JL8\u0001\u0001\t\u0004m]JT\"\u0001\u0017\n\u0005ab#!\u0003$v]\u000e$\u0018n\u001c81!\tQd(D\u0001<\u0015\taAHC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}Z$aC%oaV$8\u000b\u001e:fC6\f\u0011b\u00195v].\u001c\u0016N_3\u0011\u0005Y\u0012\u0015BA\"-\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019C\u0015\n\u0005\u0002H\u00015\t1\u0002C\u00034\u0007\u0001\u0007Q\u0007C\u0003A\u0007\u0001\u0007\u0011)A\u0002pkR,\u0012\u0001\u0014\t\u0004?5\u0013\u0013B\u0001(\u0010\u0005\u0019yU\u000f\u001e7fi\u0006!q.\u001e;!\u0003\u0015\u0019\b.\u00199f+\u0005q\u0012!E5oSRL\u0017\r\\!uiJL'-\u001e;fgV\tA\u000b\u0005\u0002 +&\u0011ak\u0004\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\u0018aH2sK\u0006$X\rT8hS\u000e\fe\u000eZ'bi\u0016\u0014\u0018.\u00197ju\u0016$g+\u00197vKR\u0011\u0011l\u0018\t\u0005mic\u0006&\u0003\u0002\\Y\t1A+\u001e9mKJ\u0002\"!G/\n\u0005yS\"aD$sCBD7\u000b^1hK2{w-[2\t\u000b\u0001D\u0001\u0019\u0001+\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0019\t\u0003I.t!!Z5\u0011\u0005\u0019dS\"A4\u000b\u0005!$\u0014A\u0002\u001fs_>$h(\u0003\u0002kY\u00051\u0001K]3eK\u001aL!\u0001\\7\u0003\rM#(/\u001b8h\u0015\tQG\u0006\u000b\u0002\u0001_B\u0011\u0001o]\u0007\u0002c*\u0011!/E\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001;r\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public final class InputStreamSource
extends GraphStageWithMaterializedValue<SourceShape<ByteString>, Future<IOResult>> {
    public final Function0<InputStream> org$apache$pekko$stream$impl$io$InputStreamSource$$factory;
    public final int org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize;
    private final Outlet<ByteString> org$apache$pekko$stream$impl$io$InputStreamSource$$out;

    public Outlet<ByteString> org$apache$pekko$stream$impl$io$InputStreamSource$$out() {
        return this.org$apache$pekko$stream$impl$io$InputStreamSource$$out;
    }

    @Override
    public SourceShape<ByteString> shape() {
        return new SourceShape<ByteString>(this.org$apache$pekko$stream$impl$io$InputStreamSource$$out());
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.inputStreamSource();
    }

    @Override
    public Tuple2<GraphStageLogic, Future<IOResult>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise mat = Promise$.MODULE$.apply();
        OutHandler logic = new OutHandler(this, mat){
            private final byte[] buffer;
            private long readBytesTotal;
            private InputStream inputStream;
            private final /* synthetic */ InputStreamSource $outer;
            private final Promise mat$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            private byte[] buffer() {
                return this.buffer;
            }

            private long readBytesTotal() {
                return this.readBytesTotal;
            }

            private void readBytesTotal_$eq(long x$1) {
                this.readBytesTotal = x$1;
            }

            private InputStream inputStream() {
                return this.inputStream;
            }

            private void inputStream_$eq(InputStream x$1) {
                this.inputStream = x$1;
            }

            private boolean isClosed() {
                return this.mat$1.isCompleted();
            }

            public Class<?> logSource() {
                return InputStreamSource.class;
            }

            public void preStart() {
                try {
                    this.inputStream_$eq(this.$outer.org$apache$pekko$stream$impl$io$InputStreamSource$$factory.apply());
                    return;
                }
                catch (Throwable throwable) {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                    if (!option.isEmpty()) {
                        Throwable t = option.get();
                        this.mat$1.failure(new IOOperationIncompleteException(0L, t));
                        this.failStage(t);
                        return;
                    }
                    throw throwable;
                }
            }

            public void onPull() {
                try {
                    int n = this.inputStream().read(this.buffer());
                    switch (n) {
                        case -1: {
                            this.closeStage();
                            break;
                        }
                        default: {
                            this.readBytesTotal_$eq(this.readBytesTotal() + (long)n);
                            this.push(this.$outer.org$apache$pekko$stream$impl$io$InputStreamSource$$out(), ByteString$.MODULE$.fromArray(this.buffer(), 0, n));
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                    if (!option.isEmpty()) {
                        Throwable t = option.get();
                        this.failStream(t);
                        this.failStage(t);
                        return;
                    }
                    throw throwable;
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                if (!this.isClosed()) {
                    this.closeInputStream();
                    if (cause instanceof SubscriptionWithCancelException.NonFailureCancellation) {
                        this.mat$1.trySuccess(IOResult$.MODULE$.apply(this.readBytesTotal()));
                        return;
                    }
                    if (cause != null) {
                        this.mat$1.tryFailure(new IOOperationIncompleteException("Downstream failed before input stream reached end", this.readBytesTotal(), cause));
                        return;
                    }
                    throw new MatchError((Object)null);
                }
            }

            public void postStop() {
                if (!this.isClosed()) {
                    this.mat$1.tryFailure(new AbruptStageTerminationException(this));
                    return;
                }
            }

            private void closeStage() {
                this.closeInputStream();
                this.mat$1.trySuccess(IOResult$.MODULE$.apply(this.readBytesTotal()));
                this.completeStage();
            }

            private void failStream(Throwable reason) {
                this.closeInputStream();
                this.mat$1.tryFailure(new IOOperationIncompleteException(this.readBytesTotal(), reason));
            }

            private void closeInputStream() {
                try {
                    if (this.inputStream() != null) {
                        this.inputStream().close();
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                    if (!option.isEmpty()) {
                        Throwable ex = option.get();
                        this.mat$1.tryFailure(new IOOperationIncompleteException(this.readBytesTotal(), ex));
                        this.failStage(ex);
                        return;
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mat$1 = mat$1;
                super($outer.shape());
                OutHandler.$init$(this);
                this.buffer = new byte[$outer.org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize];
                this.readBytesTotal = 0L;
                this.setHandler($outer.org$apache$pekko$stream$impl$io$InputStreamSource$$out(), this);
            }
        };
        return new Tuple2<GraphStageLogic, Future<IOResult>>((GraphStageLogic)((Object)logic), mat.future());
    }

    public String toString() {
        return "InputStreamSource";
    }

    public InputStreamSource(Function0<InputStream> factory, int chunkSize) {
        this.org$apache$pekko$stream$impl$io$InputStreamSource$$factory = factory;
        this.org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize = chunkSize;
        Predef$.MODULE$.require(chunkSize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(28).append("chunkSize must be > 0 (was ").append($this.org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize).append(")").toString());
        this.org$apache$pekko$stream$impl$io$InputStreamSource$$out = Outlet$.MODULE$.apply("InputStreamSource.out");
    }
}

