/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.SimpleDnsCache;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Never$;
import org.apache.pekko.io.dns.CachePolicy$Ttl$;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Ip$;
import org.apache.pekko.io.dns.DnsProtocol$Resolved$;
import org.apache.pekko.io.dns.DnsProtocol$Srv$;
import org.apache.pekko.io.dns.DnsSettings;
import org.apache.pekko.io.dns.IdGenerator;
import org.apache.pekko.io.dns.IdGenerator$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.AsyncDnsResolver$;
import org.apache.pekko.io.dns.internal.DnsClient;
import org.apache.pekko.io.dns.internal.package$CachePolicyIsOrdered$;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.PrettyDuration$PrettyPrintableDuration$;
import org.apache.pekko.util.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rEa!B\u001d;\u0005y2\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!\u0011!Q\u0001\nuC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003\u0013\u0001A\u0011AA\r\u0011%\t\t\u0003\u0001b\u0001\n\u0007\t\u0019\u0003\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0013\u0011%\t\u0019\u0004\u0001b\u0001\n\u0007\t)\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u001c\u0011%\t)\u0005\u0001b\u0001\n\u0003\t9\u0005C\u0004\u0002J\u0001\u0001\u000b\u0011\u00025\t\u0013\u0005-\u0003A1A\u0005\u0002\u00055\u0003\u0002CA6\u0001\u0001\u0006I!a\u0014\t\u0013\u00055\u0004A1A\u0005\u0002\u00055\u0003\u0002CA8\u0001\u0001\u0006I!a\u0014\t\u0013\u0005E\u0004A1A\u0005\n\u0005M\u0004bBA;\u0001\u0001\u0006I\u0001 \u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!!0\u0001\t\u0013\ty\fC\u0004\u0002d\u0002!I!!:\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u00111 \u0001\u0005\n\u0005ux\u0001\u0003B\nu!\u0005\u0001I!\u0006\u0007\u000feR\u0004\u0012\u0001!\u0003\u0018!9\u0011\u0011\u0002\u000e\u0005\u0002\te\u0001\"\u0003B\u000e5\t\u0007I\u0011\u0002B\u000f\u0011!\u0011iC\u0007Q\u0001\n\t}\u0001\"\u0003B\u00185\t\u0007I\u0011\u0002B\u000f\u0011!\u0011\tD\u0007Q\u0001\n\t}\u0001\u0002\u0003B\u001a5\u0011\u0005\u0001I!\u000e\t\u0011\t}\"\u0004\"\u0001A\u0005\u0003BqA!\u0012\u001b\t\u0013\u00119\u0005C\u0005\u0003Li\u0011\r\u0011\"\u0003\u0003N!A!q\n\u000e!\u0002\u0013\t\tM\u0002\u0004\u0003Ri\u0001%1\u000b\u0005\u000b\u0005O*#Q3A\u0005\u0002\t%\u0004B\u0003B6K\tE\t\u0015!\u0003\u0002 \"9\u0011\u0011B\u0013\u0005\u0002\t5\u0004\"\u0003B;K\u0005\u0005I\u0011\u0001B<\u0011%\u0011Y(JI\u0001\n\u0003\u0011i\bC\u0005\u0003\u0012\u0016\n\t\u0011\"\u0011\u0003\u0014\"I!qT\u0013\u0002\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005S+\u0013\u0011!C\u0001\u0005WC\u0011Ba.&\u0003\u0003%\tE!/\t\u0013\t\u001dW%!A\u0005\u0002\t%\u0007\"\u0003BgK\u0005\u0005I\u0011\tBh\u0011%\u0011\t.JA\u0001\n\u0003\u0012\u0019nB\u0005\u0003Xj\t\t\u0011#\u0001\u0003Z\u001aI!\u0011\u000b\u000e\u0002\u0002#\u0005!1\u001c\u0005\b\u0003\u0013\u0019D\u0011\u0001Bu\u0011%\u0011YoMA\u0001\n\u000b\u0012i\u000fC\u0005\u0003pN\n\t\u0011\"!\u0003r\"I!Q_\u001a\u0002\u0002\u0013\u0005%q\u001f\u0005\n\u0007\u0007\u0019\u0014\u0011!C\u0005\u0007\u000b\u0011\u0001#Q:z]\u000e$en\u001d*fg>dg/\u001a:\u000b\u0005mb\u0014\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005ur\u0014a\u00013og*\u0011q\bQ\u0001\u0003S>T!!\u0011\"\u0002\u000bA,7n[8\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\n\u0005\u0001\u001dk5\u000b\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0002\u000bQ!Y2u_JL!AU(\u0003\u000b\u0005\u001bGo\u001c:\u0011\u00059#\u0016BA+P\u00051\t5\r^8s\u0019><w-\u001b8h\u0003!\u0019X\r\u001e;j]\u001e\u001c8\u0001\u0001\t\u00033jk\u0011\u0001P\u0005\u00037r\u00121\u0002\u00128t'\u0016$H/\u001b8hg\u0006)1-Y2iKB\u0011alX\u0007\u0002}%\u0011\u0001M\u0010\u0002\u000f'&l\u0007\u000f\\3E]N\u001c\u0015m\u00195f\u00035\u0019G.[3oi\u001a\u000b7\r^8ssB)\u0001jY3iy&\u0011A-\u0013\u0002\n\rVt7\r^5p]J\u0002\"A\u00144\n\u0005\u001d|%aD!di>\u0014(+\u001a4GC\u000e$xN]=\u0011\u0007%\fHO\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011QnV\u0001\u0007yI|w\u000e\u001e \n\u0003)K!\u0001]%\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002q\u0013B\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0004]\u0016$(\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t!\rI\u0017/ \t\u0003\u001dzL!a`(\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\f1\"\u001b3HK:,'/\u0019;peB\u0019\u0011,!\u0002\n\u0007\u0005\u001dAHA\u0006JI\u001e+g.\u001a:bi>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0006\u0002\u000e\u0005E\u00111CA\u000b\u0003/\u00012!a\u0004\u0001\u001b\u0005Q\u0004\"\u0002,\u0006\u0001\u0004A\u0006\"\u0002/\u0006\u0001\u0004i\u0006\"B1\u0006\u0001\u0004\u0011\u0007bBA\u0001\u000b\u0001\u0007\u00111\u0001\u000b\t\u0003\u001b\tY\"!\b\u0002 !)aK\u0002a\u00011\")AL\u0002a\u0001;\")\u0011M\u0002a\u0001E\u0006\u0011QmY\u000b\u0003\u0003K\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003WI\u0015AC2p]\u000e,(O]3oi&!\u0011qFA\u0015\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\u0004K\u000e\u0004\u0013a\u0002;j[\u0016|W\u000f^\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\u0001\u0015\u0001B;uS2LA!!\u0011\u0002<\t9A+[7f_V$\u0018\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u00179\fW.Z*feZ,'o]\u000b\u0002Q\u0006aa.Y7f'\u0016\u0014h/\u001a:tA\u0005\u0019\u0002o\\:ji&4XmQ1dQ\u0016\u0004v\u000e\\5dsV\u0011\u0011q\n\t\u0005\u0003#\n)G\u0004\u0003\u0002T\u0005\u0005d\u0002BA+\u0003?rA!a\u0016\u0002^9!\u0011\u0011LA.\u001b\u0005\u0011\u0015BA!C\u0013\ty\u0004)\u0003\u0002>}%\u0019\u00111\r\u001f\u0002\u0017\r\u000b7\r[3Q_2L7-_\u0005\u0005\u0003O\nIGA\u0006DC\u000eDW\rU8mS\u000eL(bAA2y\u0005!\u0002o\\:ji&4XmQ1dQ\u0016\u0004v\u000e\\5ds\u0002\n1C\\3hCRLg/Z\"bG\",\u0007k\u001c7jGf\fAC\\3hCRLg/Z\"bG\",\u0007k\u001c7jGf\u0004\u0013!\u0003:fg>dg/\u001a:t+\u0005a\u0018A\u0003:fg>dg/\u001a:tA\u00059!/Z2fSZ,WCAA>!\u0011\ti(a \u000e\u0003\u0001I1!!!R\u0005\u001d\u0011VmY3jm\u0016\fAC]3t_24XmV5uQJ+7o\u001c7wKJ\u001cH\u0003CAD\u00037\u000by+a/\u0011\r\u0005\u001d\u0012\u0011RAG\u0013\u0011\tY)!\u000b\u0003\r\u0019+H/\u001e:f!\u0011\ty)!&\u000f\u0007e\u000b\t*C\u0002\u0002\u0014r\n1\u0002\u00128t!J|Go\\2pY&!\u0011qSAM\u0005!\u0011Vm]8mm\u0016$'bAAJy!9\u0011Q\u0014\u000bA\u0002\u0005}\u0015\u0001\u00028b[\u0016\u0004B!!)\u0002*:!\u00111UAS!\tY\u0017*C\u0002\u0002(&\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAV\u0003[\u0013aa\u0015;sS:<'bAAT\u0013\"9\u0011\u0011\u0017\u000bA\u0002\u0005M\u0016a\u0003:fcV,7\u000f\u001e+za\u0016\u0004B!!.\u00028:!\u00111KAI\u0013\u0011\tI,!'\u0003\u0017I+\u0017/^3tiRK\b/\u001a\u0005\u0007\u0003c\"\u0002\u0019\u0001?\u0002\u0019M,g\u000eZ)vKN$\u0018n\u001c8\u0015\r\u0005\u0005\u0017Q[Am!\u0019\t9#!#\u0002DB!\u0011QYAh\u001d\u0011\t9-a3\u000f\t\u0005M\u0013\u0011Z\u0005\u0003wqJ1!!4;\u0003%!en]\"mS\u0016tG/\u0003\u0003\u0002R\u0006M'AB!og^,'OC\u0002\u0002NjBa!a6\u0016\u0001\u0004i\u0018\u0001\u0003:fg>dg/\u001a:\t\u000f\u0005mW\u00031\u0001\u0002^\u00069Q.Z:tC\u001e,\u0007\u0003BAc\u0003?LA!!9\u0002T\nYAI\\:Rk\u0016\u001cH/[8o\u0003E\u0011Xm]8mm\u0016<\u0016\u000e\u001e5TK\u0006\u00148\r\u001b\u000b\t\u0003\u000f\u000b9/!;\u0002l\"9\u0011Q\u0014\fA\u0002\u0005}\u0005bBAY-\u0001\u0007\u00111\u0017\u0005\u0007\u0003/4\u0002\u0019A?\u0002\u0019I,7o\u001c7wK\u001aK'o\u001d;\u0015\u0011\u0005\u001d\u0015\u0011_A|\u0003sDq!a=\u0018\u0001\u0004\t)0A\u0006tK\u0006\u00148\r\u001b(b[\u0016\u001c\b\u0003B5r\u0003?Cq!!-\u0018\u0001\u0004\t\u0019\f\u0003\u0004\u0002X^\u0001\r!`\u0001\be\u0016\u001cx\u000e\u001c<f)!\t9)a@\u0003\u0002\t\r\u0001bBAO1\u0001\u0007\u0011q\u0014\u0005\b\u0003cC\u0002\u0019AAZ\u0011\u0019\t9\u000e\u0007a\u0001{\"\u001a\u0001Aa\u0002\u0011\t\t%!qB\u0007\u0003\u0005\u0017Q1A!\u0004A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005#\u0011YAA\u0006J]R,'O\\1m\u0003BL\u0017\u0001E!ts:\u001cGI\\:SKN|GN^3s!\r\tyAG\n\u00035\u001d#\"A!\u0006\u0002\u0017%\u0004h\u000fN!eIJ,7o]\u000b\u0003\u0005?\u0001BA!\t\u0003*5\u0011!1\u0005\u0006\u0005\u0005K\u00119#\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\ti$S\u0005\u0005\u0005W\u0011\u0019CA\u0003SK\u001e,\u00070\u0001\u0007jaZ$\u0014\t\u001a3sKN\u001c\b%A\u0006jaZ4\u0014\t\u001a3sKN\u001c\u0018\u0001D5qmZ\nE\r\u001a:fgN\u0004\u0013!D5t\u0013B4H'\u00113ee\u0016\u001c8\u000f\u0006\u0003\u00038\tu\u0002c\u0001%\u0003:%\u0019!1H%\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0014\u0011A\u0002\u0005}\u0015!D5t\u0013B4h'\u00113ee\u0016\u001c8\u000f\u0006\u0003\u00038\t\r\u0003bBAOC\u0001\u0007\u0011qT\u0001\u000eSNLe.\u001a;BI\u0012\u0014Xm]:\u0015\t\t]\"\u0011\n\u0005\b\u0003;\u0013\u0003\u0019AAP\u0003\u0015)U\u000e\u001d;z+\t\t\t-\u0001\u0004F[B$\u0018\u0010\t\u0002\u0017%\u0016\u001cx\u000e\u001c<f\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]N9QE!\u0016\u0003\\\t\u0005\u0004cA5\u0003X%\u0019!\u0011L:\u0003\u0013\u0015C8-\u001a9uS>t\u0007c\u0001%\u0003^%\u0019!qL%\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0001Ja\u0019\n\u0007\t\u0015\u0014J\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0002ng\u001e,\"!a(\u0002\t5\u001cx\r\t\u000b\u0005\u0005_\u0012\u0019\bE\u0002\u0003r\u0015j\u0011A\u0007\u0005\b\u0005OB\u0003\u0019AAP\u0003\u0011\u0019w\u000e]=\u0015\t\t=$\u0011\u0010\u0005\n\u0005OJ\u0003\u0013!a\u0001\u0003?\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0000)\"\u0011q\u0014BAW\t\u0011\u0019\t\u0005\u0003\u0003\u0006\n5UB\u0001BD\u0015\u0011\u0011IIa#\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0007\u0013&!!q\u0012BD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tU\u0005\u0003\u0002BL\u0005;k!A!'\u000b\u0007\tm\u00050\u0001\u0003mC:<\u0017\u0002BAV\u00053\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa)\u0011\u0007!\u0013)+C\u0002\u0003(&\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!,\u00034B\u0019\u0001Ja,\n\u0007\tE\u0016JA\u0002B]fD\u0011B!..\u0003\u0003\u0005\rAa)\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\f\u0005\u0004\u0003>\n\r'QV\u0007\u0003\u0005\u007fS1A!1J\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000b\u0014yL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001c\u0005\u0017D\u0011B!.0\u0003\u0003\u0005\rA!,\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa)\u0002\r\u0015\fX/\u00197t)\u0011\u00119D!6\t\u0013\tU\u0016'!AA\u0002\t5\u0016A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\tE4gE\u00034\u0005;\u0014\t\u0007\u0005\u0005\u0003`\n\u0015\u0018q\u0014B8\u001b\t\u0011\tOC\u0002\u0003d&\u000bqA];oi&lW-\u0003\u0003\u0003h\n\u0005(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!\u0011\\\u0001\ti>\u001cFO]5oOR\u0011!QS\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005_\u0012\u0019\u0010C\u0004\u0003hY\u0002\r!a(\u0002\u000fUt\u0017\r\u001d9msR!!\u0011 B\u0000!\u0015A%1`AP\u0013\r\u0011i0\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\r\u0005q'!AA\u0002\t=\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00199\u0001\u0005\u0003\u0003\u0018\u000e%\u0011\u0002BB\u0006\u00053\u0013aa\u00142kK\u000e$\bf\u0001\u000e\u0003\b!\u001a\u0011Da\u0002")
@InternalApi
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final SimpleDnsCache org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache;
    private final IdGenerator idGenerator;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private final List<ActorRef> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    public List<ActorRef> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)x1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache.get(new Tuple2<String, DnsProtocol.RequestType>(name, mode = resolve.requestType()));
                    if (option instanceof Some) {
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)((Some)option).value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        this.$outer.sender().$bang(resolved2, this.$outer.self());
                    } else if (None$.MODULE$.equals(option)) {
                        package$.MODULE$.pipe(this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1<DnsProtocol.Resolved, DnsProtocol.Resolved> & Serializable & scala.Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.positiveCachePolicy();
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((TraversableOnce)((SeqLike)resolved.records().map((Function1<ResourceRecord, CachePolicy.Ttl> & Serializable & scala.Serializable)x$5 -> x$5.ttl(), Seq$.MODULE$.canBuildFrom())).$plus$colon(cachePolicy, Seq$.MODULE$.canBuildFrom())).min(package$CachePolicyIsOrdered$.MODULE$);
                                $this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(name, mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    $this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(name, mode), (DnsProtocol.Resolved)resolved, $this.$outer.negativeCachePolicy());
                                }
                            }
                            $this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, this.$outer.ec()), this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    } else {
                        throw new MatchError(option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof DnsProtocol.Resolve;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.pekko.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String org.apache.pekko.io.dns.DnsProtocol$RequestType org.apache.pekko.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(org.apache.pekko.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        if (AsyncDnsResolver$.MODULE$.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0<DnsProtocol.Resolved> & Serializable & scala.Serializable)() -> {
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                if (address instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (address instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)address;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(20).append("Unexpected address: ").append(address).toString());
                }
                ResourceRecord record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, Nil$.MODULE$.$colon$colon(record));
            }));
        }
        if (((Object)Nil$.MODULE$).equals(resolvers)) {
            return Future$.MODULE$.failed(new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
        }
        if (resolvers instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)resolvers;
            ActorRef head = (ActorRef)$colon$colon.head();
            List tail = $colon$colon.tl$access$1();
            return this.resolveWithSearch(name, requestType, head).recoverWith(new scala.Serializable(this, name, requestType, tail){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDnsResolver $outer;
                private final String name$2;
                private final DnsProtocol.RequestType requestType$1;
                private final List tail$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(x1);
                    if (!option.isEmpty()) {
                        Throwable t = option.get();
                        if (t instanceof AskTimeoutException) {
                            this.$outer.log().info("Resolve of {} timed out after {}. Trying next name server", this.name$2, PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension0(PrettyDuration$.MODULE$.PrettyPrintableDuration(this.$outer.timeout().duration())));
                        } else {
                            this.$outer.log().info("Resolve of {} failed. Trying next name server {}", this.name$2, t.getMessage());
                        }
                        return (B1)this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, this.tail$1);
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return !NonFatal$.MODULE$.unapply(x1).isEmpty();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.name$2 = name$2;
                    this.requestType$1 = requestType$1;
                    this.tail$1 = tail$1;
                }
            }, this.ec());
        }
        throw new MatchError(resolvers);
    }

    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        return AskableActorRef$.MODULE$.$qmark$extension1(package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).transformWith((Function1<Try, Future> & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Success success = null;
            if (x0$1 instanceof Success) {
                bl = true;
                success = (Success)x0$1;
                Object result = success.value();
                if (result instanceof DnsClient.Answer) {
                    DnsClient.Answer answer = (DnsClient.Answer)result;
                    return Future$.MODULE$.successful(answer);
                }
            }
            if (bl && success.value() instanceof DnsClient.DuplicateId) {
                return this.sendQuestion(resolver, message.withId($this.idGenerator.nextId()));
            }
            if (x0$1 instanceof Failure) {
                Throwable t = ((Failure)x0$1).exception();
                resolver.$bang(new DnsClient.DropRequest(message), this.self());
                return Future$.MODULE$.failed(t);
            }
            if (bl) {
                Object a = success.value();
                resolver.$bang(new DnsClient.DropRequest(message), this.self());
                return Future$.MODULE$.failed(new IllegalArgumentException(new StringBuilder(29).append("Unexpected response ").append(a.toString()).append(" of type ").append(a.getClass().toString()).toString()));
            }
            throw new MatchError(x0$1);
        }, this.ec());
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        if (this.settings.SearchDomains().nonEmpty()) {
            List<?> nameWithSearch = this.settings.SearchDomains().map((Function1<String, String> & Serializable & scala.Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString(), List$.MODULE$.canBuildFrom());
            List<String> toResolve = new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1<Object, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar(x$8)))) >= this.settings.NDots() ? nameWithSearch.$colon$colon(name) : nameWithSearch.$colon$plus(name, List$.MODULE$.canBuildFrom());
            return this.resolveFirst(toResolve, requestType, resolver);
        }
        return this.resolve(name, requestType, resolver);
    }

    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        boolean bl = false;
        $colon$colon $colon$colon = null;
        if (searchNames instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)searchNames;
            String searchName = (String)$colon$colon.head();
            List list = $colon$colon.tl$access$1();
            if (((Object)Nil$.MODULE$).equals(list)) {
                return this.resolve(searchName, requestType, resolver);
            }
        }
        if (bl) {
            String searchName = (String)$colon$colon.head();
            List remaining = $colon$colon.tl$access$1();
            return this.resolve(searchName, requestType, resolver).flatMap((Function1<DnsProtocol.Resolved, Future> & Serializable & scala.Serializable)resolved -> {
                if (resolved.records().isEmpty()) {
                    return this.resolveFirst(remaining, requestType, resolver);
                }
                return Future$.MODULE$.successful(resolved);
            }, this.ec());
        }
        if (((Object)Nil$.MODULE$).equals(searchNames)) {
            return Future$.MODULE$.failed(new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
        }
        throw new MatchError(searchNames);
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        if (requestType instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.idGenerator.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.idGenerator.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$Empty();
            return ipv4Recs.flatMap((Function1<DnsClient.Answer, Future> & Serializable & scala.Serializable)ipv4 -> ipv6Recs.map((Function1<DnsClient.Answer, DnsProtocol.Resolved> & Serializable & scala.Serializable)ipv6 -> new DnsProtocol.Resolved(name, ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom()), ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom())), this.ec()), this.ec());
        }
        if (DnsProtocol$Srv$.MODULE$.equals(requestType)) {
            return this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.idGenerator.nextId(), caseFoldedName)).map((Function1<DnsClient.Answer, DnsProtocol.Resolved> & Serializable & scala.Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), this.ec());
        }
        throw new MatchError(requestType);
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$8) {
        return x$8 == '.';
    }

    /*
     * WARNING - void declaration
     */
    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory, IdGenerator idGenerator) {
        void var8_9;
        void var7_8;
        InetAddress inetAddress;
        InetAddress inetAddress2;
        this.settings = settings;
        this.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$cache = cache;
        this.idGenerator = idGenerator;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        InetAddress loopback = InetAddress.getLoopbackAddress();
        if (loopback instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)loopback;
            inetAddress2 = InetAddress.getByName("127.0.0.1");
            inetAddress = inet6Address;
        } else if (loopback instanceof Inet4Address) {
            inetAddress2 = (Inet4Address)loopback;
            inetAddress = InetAddress.getByName("::1");
        } else {
            throw new IllegalArgumentException(new StringBuilder(23).append("Loopback address was [").append(loopback).append("]").toString());
        }
        InetAddress inetAddress3 = inetAddress;
        InetAddress ipv4Address = inetAddress2;
        InetAddress ipv6Address = inetAddress3;
        void ipv4Address2 = var7_8;
        void ipv6Address2 = var8_9;
        ARecord aRecord = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), loopback);
        cache.put(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("localhost"), new DnsProtocol.Ip(DnsProtocol$Ip$.MODULE$.apply$default$1(), DnsProtocol$Ip$.MODULE$.apply$default$2())), DnsProtocol$Resolved$.MODULE$.apply("localhost", Nil$.MODULE$.$colon$colon(aRecord)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        boolean x$1 = false;
        boolean x$2 = true;
        ARecord aRecord2 = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), (InetAddress)ipv4Address2);
        cache.put(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("localhost"), new DnsProtocol.Ip(x$2, x$1)), DnsProtocol$Resolved$.MODULE$.apply("localhost", Nil$.MODULE$.$colon$colon(aRecord2)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        boolean x$3 = true;
        boolean x$4 = false;
        ARecord aRecord3 = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), (InetAddress)ipv6Address2);
        cache.put(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("localhost"), new DnsProtocol.Ip(x$4, x$3)), DnsProtocol$Resolved$.MODULE$.apply("localhost", Nil$.MODULE$.$colon$colon(aRecord3)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger(settings.NDots()));
        this.org$apache$pekko$io$dns$internal$AsyncDnsResolver$$resolvers = clientFactory.apply(this.context(), this.nameServers());
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this(settings, cache, clientFactory, IdGenerator$.MODULE$.apply(settings.IdGeneratorPolicy()));
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        @Override
        public String productPrefix() {
            return "ResolveFailedException";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.msg();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        @Override
        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ResolveFailedException)) break block3;
                    ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
                    String string = this.msg();
                    String string2 = resolveFailedException.msg();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !resolveFailedException.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$(this);
        }
    }
}

