/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.lang.reflect.Array;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class HashCode$ {
    public static HashCode$ MODULE$;
    private final int SEED;
    private final int PRIME;

    static {
        new HashCode$();
    }

    public int SEED() {
        return this.SEED;
    }

    public int hash(int seed, Object any) {
        if (any instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean(any);
            return this.hash(seed, bl);
        }
        if (any instanceof Character) {
            char c = BoxesRunTime.unboxToChar(any);
            return this.hash(seed, c);
        }
        if (any instanceof Short) {
            short s = BoxesRunTime.unboxToShort(any);
            return this.hash(seed, s);
        }
        if (any instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(any);
            return this.hash(seed, n);
        }
        if (any instanceof Long) {
            long l = BoxesRunTime.unboxToLong(any);
            return this.hash(seed, l);
        }
        if (any instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(any);
            return this.hash(seed, f);
        }
        if (any instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(any);
            return this.hash(seed, d);
        }
        if (any instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(any);
            return this.hash(seed, by);
        }
        if (any instanceof Object) {
            IntRef result = IntRef.create(seed);
            if (any == null) {
                result.elem = this.hash(result.elem, 0);
            } else if (!this.isArray(any)) {
                result.elem = this.hash(result.elem, any.hashCode());
            } else {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Array.getLength(any)).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)id -> {
                    result$1.elem = MODULE$.hash(result$1.elem, Array.get(any, id));
                });
            }
            return result.elem;
        }
        throw new IllegalArgumentException(new StringBuilder(27).append("Unexpected hash parameter: ").append(any).toString());
    }

    public int hash(int seed, boolean value) {
        return this.firstTerm(seed) + (value ? 1 : 0);
    }

    public int hash(int seed, char value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, int value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, long value) {
        return this.firstTerm(seed) + (int)(value ^ value >>> 32);
    }

    public int hash(int seed, float value) {
        return this.hash(seed, Float.floatToIntBits(value));
    }

    public int hash(int seed, double value) {
        return this.hash(seed, Double.doubleToLongBits(value));
    }

    private int firstTerm(int seed) {
        return this.PRIME() * seed;
    }

    private boolean isArray(Object anyRef) {
        return anyRef.getClass().isArray();
    }

    private int PRIME() {
        return this.PRIME;
    }

    private HashCode$() {
        MODULE$ = this;
        this.SEED = 23;
        this.PRIME = 37;
    }
}

