/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io.compression;

import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.io.compression.DeflateCompressor;
import org.apache.pekko.stream.impl.io.compression.GzipCompressor$;
import org.apache.pekko.stream.impl.io.compression.GzipDecompressor$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Predef$;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!\u0002\f\u0018\u0001})\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000bI\u0002A\u0011A\u001a\t\u0011Y\u0002\u0001R1A\u0005R]BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0011\u001di\u0005\u00011A\u0005\n9Ca\u0001\u0016\u0001!B\u0013Q\u0005bB+\u0001\u0001\u0004%IA\u0016\u0005\b5\u0002\u0001\r\u0011\"\u0003\\\u0011\u0019i\u0006\u0001)Q\u0005/\")a\f\u0001C)?\")q\u000e\u0001C)a\")!\u000f\u0001C)g\")Q\u000f\u0001C\u0005m\")\u0001\u0010\u0001C\u0005s\")!\u0010\u0001C\u0005s\u001eQ\u0011QA\f\u0002\u0002#\u0005q$a\u0002\u0007\u0013Y9\u0012\u0011!E\u0001?\u0005%\u0001B\u0002\u001a\u0014\t\u0003\t\t\u0002C\u0005\u0002\u0014M\t\n\u0011\"\u0001\u0002\u0016\tqqI_5q\u0007>l\u0007O]3tg>\u0014(B\u0001\r\u001a\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005iY\u0012AA5p\u0015\taR$\u0001\u0003j[Bd'B\u0001\u0010 \u0003\u0019\u0019HO]3b[*\u0011\u0001%I\u0001\u0006a\u0016\\7n\u001c\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0005\u0002\u0001MA\u0011q\u0005K\u0007\u0002/%\u0011\u0011f\u0006\u0002\u0012\t\u00164G.\u0019;f\u0007>l\u0007O]3tg>\u0014\u0018\u0001E2p[B\u0014Xm]:j_:dUM^3m\u0007\u0001\u0001\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0011A'\u000e\t\u0003O\u0001AqA\u000b\u0002\u0011\u0002\u0003\u0007A&\u0001\u0005eK\u001ad\u0017\r^3s+\u0005A\u0004CA\u001dA\u001b\u0005Q$BA\u001e=\u0003\rQ\u0018\u000e\u001d\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!;\u0005!!UM\u001a7bi\u0016\u0014\u0018\u0001C2iK\u000e\\7+^7\u0016\u0003\u0011\u0003\"!O#\n\u0005\u0019S$!B\"S\u0007N\u0012\u0014!C2iK\u000e\\7+^7!\u0003)AW-\u00193feN+g\u000e^\u000b\u0002\u0015B\u0011QfS\u0005\u0003\u0019:\u0012qAQ8pY\u0016\fg.\u0001\biK\u0006$WM]*f]R|F%Z9\u0015\u0005=\u0013\u0006CA\u0017Q\u0013\t\tfF\u0001\u0003V]&$\bbB*\b\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\n\u0014a\u00035fC\u0012,'oU3oi\u0002\n\u0011BY=uKN\u0014V-\u00193\u0016\u0003]\u0003\"!\f-\n\u0005es#\u0001\u0002'p]\u001e\fQBY=uKN\u0014V-\u00193`I\u0015\fHCA(]\u0011\u001d\u0019&\"!AA\u0002]\u000b!BY=uKN\u0014V-\u00193!\u0003I\u0019w.\u001c9sKN\u001cx+\u001b;i\u0005V4g-\u001a:\u0015\u0007\u0001,w\r\u0005\u0002bG6\t!M\u0003\u0002>?%\u0011AM\u0019\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007\"\u00024\r\u0001\u0004\u0001\u0017!B5oaV$\b\"\u00025\r\u0001\u0004I\u0017A\u00022vM\u001a,'\u000fE\u0002.U2L!a\u001b\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00055j\u0017B\u00018/\u0005\u0011\u0011\u0015\u0010^3\u0002\u001f\u0019dWo\u001d5XSRD')\u001e4gKJ$\"\u0001Y9\t\u000b!l\u0001\u0019A5\u0002!\u0019Lg.[:i/&$\bNQ;gM\u0016\u0014HC\u00011u\u0011\u0015Ag\u00021\u0001j\u0003%)\b\u000fZ1uK\u000e\u00138\r\u0006\u0002Po\")am\u0004a\u0001A\u00061\u0001.Z1eKJ$\u0012\u0001Y\u0001\biJ\f\u0017\u000e\\3sQ\t\u0001A\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f~\t!\"\u00198o_R\fG/[8o\u0013\r\t\u0019A \u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.\u0001\bHu&\u00048i\\7qe\u0016\u001c8o\u001c:\u0011\u0005\u001d\u001a2cA\n\u0002\fA\u0019Q&!\u0004\n\u0007\u0005=aF\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u000f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA\fU\ra\u0013\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002&5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0011qPL\u0005\u0005\u0003O\tyBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final int compressionLevel;
    private final CRC32 checkSum;
    private boolean headerSent;
    private long bytesRead;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$1() {
        return GzipCompressor$.MODULE$.$lessinit$greater$default$1();
    }

    private Deflater deflater$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(this.compressionLevel, true);
                this.bitmap$0 = true;
            }
        }
        return this.deflater;
    }

    @Override
    public Deflater deflater() {
        if (!this.bitmap$0) {
            return this.deflater$lzycompute();
        }
        return this.deflater;
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update(input.toArrayUnsafe());
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        if (!this.headerSent()) {
            this.headerSent_$eq(true);
            return GzipDecompressor$.MODULE$.Header();
        }
        return ByteString$.MODULE$.empty();
    }

    private ByteString trailer() {
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        return GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), Numeric$IntIsIntegral$.MODULE$);
    }

    public GzipCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        super(compressionLevel, true);
        this.checkSum = new CRC32();
        this.headerSent = false;
        this.bytesRead = 0L;
    }
}

