/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import org.apache.pekko.actor.ActorRef;

public class CountMinSketch {
    private int depth;
    private int width;
    private long[][] table;
    private long size;
    private double eps;
    private double confidence;
    private int[] recyclableCMSHashBuckets;

    public CountMinSketch(int n, int n2, int n3) {
        if ((n2 & n2 - 1) != 0) {
            throw new IllegalArgumentException("width must be a power of 2, was: " + n2);
        }
        this.depth = n;
        this.width = n2;
        this.eps = 2.0 / (double)n2;
        this.confidence = 1.0 - 1.0 / Math.pow(2.0, n);
        this.recyclableCMSHashBuckets = this.preallocateHashBucketsArray(n);
        this.initTablesWith(n, n2, n3);
    }

    private void initTablesWith(int n, int n2, int n3) {
        this.table = new long[n][n2];
    }

    public double relativeError() {
        return this.eps;
    }

    public double confidence() {
        return this.confidence;
    }

    public long addObjectAndEstimateCount(Object object, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        Murmur3.hashBuckets(object, this.recyclableCMSHashBuckets, this.width);
        for (int i = 0; i < this.depth; ++i) {
            long[] lArray = this.table[i];
            int n = this.recyclableCMSHashBuckets[i];
            lArray[n] = lArray[n] + l;
        }
        this.size += l;
        return this.estimateCount(this.recyclableCMSHashBuckets);
    }

    public long size() {
        return this.size;
    }

    public long estimateCount(Object object) {
        Murmur3.hashBuckets(object, this.recyclableCMSHashBuckets, this.width);
        return this.estimateCount(this.recyclableCMSHashBuckets);
    }

    private long estimateCount(int[] nArray) {
        long l = Long.MAX_VALUE;
        for (int i = 0; i < this.depth; ++i) {
            l = Math.min(l, this.table[i][nArray[i]]);
        }
        return l;
    }

    private int[] preallocateHashBucketsArray(int n) {
        return new int[n];
    }

    public String toString() {
        return "CountMinSketch{confidence=" + this.confidence + ", size=" + this.size + ", depth=" + this.depth + ", width=" + this.width + '}';
    }

    private static class Murmur3 {
        private Murmur3() {
        }

        private static int avalanche(int n) {
            int n2 = n;
            n2 ^= n2 >>> 16;
            n2 *= -2048144789;
            n2 ^= n2 >>> 13;
            n2 *= -1028477387;
            n2 ^= n2 >>> 16;
            return n2;
        }

        private static int mixLast(int n, int n2) {
            int n3 = n2;
            n3 *= -862048943;
            n3 = Integer.rotateLeft(n3, 15);
            return n ^ (n3 *= 461845907);
        }

        private static int mix(int n, int n2) {
            int n3 = Murmur3.mixLast(n, n2);
            n3 = Integer.rotateLeft(n3, 13);
            return n3 * 5 + -430675100;
        }

        public static int hash(Object object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof ActorRef) {
                return object.hashCode();
            }
            if (object instanceof String) {
                return Murmur3.hash(((String)object).getBytes());
            }
            if (object instanceof Long) {
                return Murmur3.hashLong((Long)object, 0);
            }
            if (object instanceof Integer) {
                return Murmur3.hashLong(((Integer)object).intValue(), 0);
            }
            if (object instanceof Double) {
                return Murmur3.hashLong(Double.doubleToRawLongBits((Double)object), 0);
            }
            if (object instanceof Float) {
                return Murmur3.hashLong(Float.floatToRawIntBits(((Float)object).floatValue()), 0);
            }
            if (object instanceof byte[]) {
                return Murmur3.bytesHash((byte[])object, 0);
            }
            return Murmur3.hash(object.toString());
        }

        static int hashLong(long l, int n) {
            int n2 = n;
            n2 = Murmur3.mix(n2, (int)l);
            n2 = Murmur3.mixLast(n2, (int)(l >>> 32));
            return Murmur3.avalanche(n2 ^ 2);
        }

        static int bytesHash(byte[] byArray, int n) {
            int n2;
            int n3;
            int n4 = n;
            int n5 = 0;
            for (n3 = byArray.length; n3 >= 4; n3 -= 4) {
                n2 = byArray[n5] & 0xFF;
                n2 |= (byArray[n5 + 1] & 0xFF) << 8;
                n2 |= (byArray[n5 + 2] & 0xFF) << 16;
                n4 = Murmur3.mix(n4, n2 |= (byArray[n5 + 3] & 0xFF) << 24);
                n5 += 4;
            }
            n2 = 0;
            if (n3 == 3) {
                n2 ^= (byArray[n5 + 2] & 0xFF) << 16;
            }
            if (n3 >= 2) {
                n2 ^= (byArray[n5 + 1] & 0xFF) << 8;
            }
            if (n3 >= 1) {
                n4 = Murmur3.mixLast(n4, n2 ^= byArray[n5] & 0xFF);
            }
            return Murmur3.avalanche(n4 ^ byArray.length);
        }

        static void hashBuckets(Object object, int[] nArray, int n) {
            int n2 = Murmur3.hash(object);
            int n3 = Murmur3.hashLong(n2, n2);
            int n4 = nArray.length;
            int n5 = n - 1;
            for (int i = 0; i < n4; ++i) {
                nArray[i] = Math.abs(n2 + i * n3 & n5);
            }
        }
    }
}

