/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaVersion$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.util.control.NonFatal$;

@InternalApi
public final class VirtualThreadSupport$ {
    public static VirtualThreadSupport$ MODULE$;
    private final MethodHandles.Lookup lookup;
    private final boolean isSupported;

    static {
        new VirtualThreadSupport$();
    }

    private MethodHandles.Lookup lookup() {
        return this.lookup;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public ThreadFactory newVirtualThreadFactory(String prefix) {
        Predef$.MODULE$.require(this.isSupported(), (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "Virtual thread is not supported.");
        try {
            Class<?> builderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder");
            Class<?> ofVirtualClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder$OfVirtual");
            Object builder = this.lookup().findStatic(Thread.class, "ofVirtual", MethodType.methodType(ofVirtualClass)).invoke();
            MethodHandle nameMethod = this.lookup().findVirtual(ofVirtualClass, "name", MethodType.methodType(ofVirtualClass, String.class, Long.TYPE));
            MethodHandle factoryMethod = this.lookup().findVirtual(builderClass, "factory", MethodType.methodType(ThreadFactory.class));
            builder = nameMethod.invoke(builder, new StringBuilder(16).append(prefix).append("-virtual-thread-").toString(), 0L);
            return (ThreadFactory)factoryMethod.invoke(builder);
        }
        catch (Throwable throwable) {
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                throw new UnsupportedOperationException("Failed to create virtual thread factory", e);
            }
            throw throwable;
        }
    }

    public ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        Predef$.MODULE$.require(threadFactory != null, (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "threadFactory should not be null.");
        try {
            Class<?> executorsClazz = ClassLoader.getSystemClassLoader().loadClass("java.util.concurrent.Executors");
            return (ExecutorService)this.lookup().findStatic(executorsClazz, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class)).invoke(threadFactory);
        }
        catch (Throwable throwable) {
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                throw new UnsupportedOperationException("Failed to create newThreadPerTaskExecutor.", e);
            }
            throw throwable;
        }
    }

    private VirtualThreadSupport$() {
        MODULE$ = this;
        this.lookup = MethodHandles.publicLookup();
        this.isSupported = JavaVersion$.MODULE$.majorVersion() >= 21;
    }
}

