/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

final class RpcSerializedValue
implements Serializable {
    private static final long serialVersionUID = -4388571068440835689L;
    @Nullable
    private final byte[] serializedData;

    private RpcSerializedValue(@Nullable byte[] serializedData) {
        this.serializedData = serializedData;
    }

    @Nullable
    public byte[] getSerializedData() {
        return this.serializedData;
    }

    public int getSerializedDataLength() {
        return this.serializedData == null ? 0 : this.serializedData.length;
    }

    @Nullable
    public <T> T deserializeValue(ClassLoader loader) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)loader, (String)"No classloader has been passed");
        return (T)(this.serializedData == null ? null : InstantiationUtil.deserializeObject((byte[])this.serializedData, (ClassLoader)loader));
    }

    public static RpcSerializedValue valueOf(@Nullable Object value) throws IOException {
        byte[] serializedData = value == null ? null : InstantiationUtil.serializeObject((Object)value);
        return new RpcSerializedValue(serializedData);
    }

    public boolean equals(Object o) {
        if (o instanceof RpcSerializedValue) {
            RpcSerializedValue other = (RpcSerializedValue)o;
            return Arrays.equals(this.serializedData, other.serializedData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedData);
    }

    public String toString() {
        return this.serializedData == null ? "RpcSerializedValue(null)" : "RpcSerializedValue";
    }
}

