/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.formats.parquet.ParquetFileFormatFactory;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetSchemaConverter {
    static final String MAP_REPEATED_NAME = "key_value";
    static final String LIST_ELEMENT_NAME = "element";

    public static MessageType convertToParquetMessageType(String name, RowType rowType, Configuration conf) {
        Type[] types = new Type[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            types[i] = ParquetSchemaConverter.convertToParquetType((String)rowType.getFieldNames().get(i), rowType.getTypeAt(i), conf);
        }
        return new MessageType(name, types);
    }

    public static Type convertToParquetType(String name, LogicalType type, Configuration conf) {
        Type.Repetition repetition = type.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        return ParquetSchemaConverter.convertToParquetType(name, type, repetition, conf);
    }

    private static Type convertToParquetType(String name, LogicalType type, Type.Repetition repetition, Configuration conf) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(name);
            }
            case BOOLEAN: {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
            }
            case BINARY: 
            case VARBINARY: {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                int numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).precision(precision)).scale(scale)).length(numBytes)).as(OriginalType.DECIMAL)).named(name);
            }
            case TINYINT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(name);
            }
            case SMALLINT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(name);
            }
            case INTEGER: {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
            }
            case BIGINT: {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
            }
            case FLOAT: {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
            }
            case DOUBLE: {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(name);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.TIME_MILLIS)).named(name);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (conf.getBoolean("parquet." + ParquetFileFormatFactory.WRITE_INT64_TIMESTAMP.key(), ((Boolean)ParquetFileFormatFactory.WRITE_INT64_TIMESTAMP.defaultValue()).booleanValue())) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = LogicalTypeAnnotation.TimeUnit.valueOf((String)conf.get("parquet." + ParquetFileFormatFactory.TIMESTAMP_TIME_UNIT.key(), (String)ParquetFileFormatFactory.TIMESTAMP_TIME_UNIT.defaultValue()).toUpperCase());
                    return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)timeUnit))).named(name);
                }
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return ConversionPatterns.listOfElements((Type.Repetition)repetition, (String)name, (Type)ParquetSchemaConverter.convertToParquetType(LIST_ELEMENT_NAME, arrayType.getElementType(), conf));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                LogicalType keyType = mapType.getKeyType();
                if (keyType.isNullable()) {
                    keyType = keyType.copy(false);
                }
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)name, (String)MAP_REPEATED_NAME, (Type)ParquetSchemaConverter.convertToParquetType("key", keyType, conf), (Type)ParquetSchemaConverter.convertToParquetType("value", mapType.getValueType(), conf));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)type;
                LogicalType elementType = multisetType.getElementType();
                if (elementType.isNullable()) {
                    elementType = elementType.copy(false);
                }
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)name, (String)MAP_REPEATED_NAME, (Type)ParquetSchemaConverter.convertToParquetType("key", elementType, conf), (Type)ParquetSchemaConverter.convertToParquetType("value", (LogicalType)new IntType(false), conf));
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new GroupType(repetition, name, ParquetSchemaConverter.convertToParquetTypes(rowType, conf));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static List<Type> convertToParquetTypes(RowType rowType, Configuration conf) {
        ArrayList<Type> types = new ArrayList<Type>(rowType.getFieldCount());
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            types.add(ParquetSchemaConverter.convertToParquetType((String)rowType.getFieldNames().get(i), rowType.getTypeAt(i), conf));
        }
        return types;
    }

    public static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    public static boolean is32BitDecimal(int precision) {
        return precision <= 9;
    }

    public static boolean is64BitDecimal(int precision) {
        return precision <= 18 && precision > 9;
    }
}

