/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector;

import org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.data.TimestampData;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetDictionary
implements org.apache.flink.table.data.columnar.vector.Dictionary {
    private Dictionary dictionary;
    private final ColumnDescriptor descriptor;

    public ParquetDictionary(Dictionary dictionary, ColumnDescriptor descriptor) {
        this.dictionary = dictionary;
        this.descriptor = descriptor;
    }

    public int decodeToInt(int id) {
        return this.dictionary.decodeToInt(id);
    }

    public long decodeToLong(int id) {
        return this.dictionary.decodeToLong(id);
    }

    public float decodeToFloat(int id) {
        return this.dictionary.decodeToFloat(id);
    }

    public double decodeToDouble(int id) {
        return this.dictionary.decodeToDouble(id);
    }

    public byte[] decodeToBinary(int id) {
        return this.dictionary.decodeToBinary(id).getBytesUnsafe();
    }

    public TimestampData decodeToTimestamp(int id) {
        if (this.descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            return TimestampColumnReader.decodeInt64ToTimestamp(true, this.dictionary, id, ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)this.descriptor.getPrimitiveType().getLogicalTypeAnnotation()).getUnit());
        }
        return TimestampColumnReader.decodeInt96ToTimestamp(true, this.dictionary, id);
    }
}

