/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.orc.data.Record;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class OrcBulkWriterTestUtil {
    public static final String USER_METADATA_KEY = "userKey";
    public static final ByteBuffer USER_METADATA_VALUE = ByteBuffer.wrap("hello".getBytes());

    public static void validate(File files, List<Record> expected) throws IOException {
        Object[] buckets = files.listFiles();
        Assertions.assertThat((Object[])buckets).isNotNull();
        Assertions.assertThat((Object[])buckets).hasSize(1);
        Object[] partFiles = ((File)buckets[0]).listFiles();
        Assertions.assertThat((Object[])partFiles).isNotNull();
        for (Object partFile : partFiles) {
            Assertions.assertThat((long)((File)partFile).length()).isGreaterThan(0L);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
            Reader reader = OrcFile.createReader((Path)new Path(((File)partFile).toURI()), (OrcFile.ReaderOptions)readerOptions);
            Assertions.assertThat((long)reader.getNumberOfRows()).isEqualTo(3L);
            Assertions.assertThat((List)reader.getSchema().getFieldNames()).hasSize(2);
            Assertions.assertThat((Comparable)reader.getCompressionKind()).isSameAs((Object)CompressionKind.LZ4);
            Assertions.assertThat((boolean)reader.hasMetadataValue(USER_METADATA_KEY)).isTrue();
            Assertions.assertThat((List)reader.getMetadataKeys()).contains((Object[])new String[]{USER_METADATA_KEY});
            List<Record> results = OrcBulkWriterTestUtil.getResults(reader);
            ((ListAssert)Assertions.assertThat(results).hasSize(3)).isEqualTo(expected);
        }
    }

    private static List<Record> getResults(Reader reader) throws IOException {
        ArrayList<Record> results = new ArrayList<Record>();
        RecordReader recordReader = reader.rows();
        VectorizedRowBatch batch = reader.getSchema().createRowBatch();
        while (recordReader.nextBatch(batch)) {
            BytesColumnVector stringVector = (BytesColumnVector)batch.cols[0];
            LongColumnVector intVector = (LongColumnVector)batch.cols[1];
            for (int r = 0; r < batch.size; ++r) {
                String name = new String(stringVector.vector[r], stringVector.start[r], stringVector.length[r]);
                int age = (int)intVector.vector[r];
                results.add(new Record(name, age));
            }
            recordReader.close();
        }
        return results;
    }
}

