/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OrcFileSystemFilterTest {
    OrcFileSystemFilterTest() {
    }

    @Test
    void testApplyPredicate() {
        ArrayList<Object> args = new ArrayList<Object>();
        FieldReferenceExpression fieldReferenceExpression = new FieldReferenceExpression("long1", DataTypes.BIGINT(), 0, 0);
        ValueLiteralExpression valueLiteralExpression = new ValueLiteralExpression((Object)10);
        args.add(fieldReferenceExpression);
        args.add(valueLiteralExpression);
        CallExpression equalExpression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, args, (DataType)DataTypes.BOOLEAN());
        OrcFilters.Predicate predicate1 = OrcFilters.toOrcPredicate((Expression)equalExpression);
        OrcFilters.Equals predicate2 = new OrcFilters.Equals("long1", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10));
        Assertions.assertThat((Object)predicate1).hasToString(predicate2.toString());
        CallExpression greaterExpression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, args, (DataType)DataTypes.BOOLEAN());
        OrcFilters.Predicate predicate3 = OrcFilters.toOrcPredicate((Expression)greaterExpression);
        OrcFilters.Not predicate4 = new OrcFilters.Not((OrcFilters.Predicate)new OrcFilters.LessThanEquals("long1", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10)));
        Assertions.assertThat((Object)predicate3).hasToString(predicate4.toString());
        CallExpression lessExpression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, args, (DataType)DataTypes.BOOLEAN());
        OrcFilters.Predicate predicate5 = OrcFilters.toOrcPredicate((Expression)lessExpression);
        OrcFilters.LessThan predicate6 = new OrcFilters.LessThan("long1", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10));
        Assertions.assertThat((Object)predicate5).hasToString(predicate6.toString());
        CallExpression andExpression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(greaterExpression, lessExpression), (DataType)DataTypes.BOOLEAN());
        OrcFilters.Predicate predicate7 = OrcFilters.toOrcPredicate((Expression)andExpression);
        OrcFilters.And predicate8 = new OrcFilters.And(new OrcFilters.Predicate[]{predicate4, predicate6});
        Assertions.assertThat((Object)predicate7).hasToString(predicate8.toString());
    }

    @Test
    void testApplyPredicateReverse() {
        ArrayList<Object> args = new ArrayList<Object>();
        FieldReferenceExpression fieldReferenceExpression = new FieldReferenceExpression("x", DataTypes.BIGINT(), 0, 0);
        ValueLiteralExpression valueLiteralExpression = new ValueLiteralExpression((Object)10);
        args.add(valueLiteralExpression);
        args.add(fieldReferenceExpression);
        CallExpression expression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, args, (DataType)DataTypes.BOOLEAN());
        OrcFilters.LessThanEquals predicate = new OrcFilters.LessThanEquals("x", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10));
        Assertions.assertThat((Object)OrcFilters.toOrcPredicate((Expression)expression)).hasToString(predicate.toString());
        expression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, args, (DataType)DataTypes.BOOLEAN());
        predicate = new OrcFilters.LessThan("x", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10));
        Assertions.assertThat((Object)OrcFilters.toOrcPredicate((Expression)expression)).hasToString(predicate.toString());
        expression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, args, (DataType)DataTypes.BOOLEAN());
        predicate = new OrcFilters.Not((OrcFilters.Predicate)new OrcFilters.LessThan("x", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10)));
        Assertions.assertThat((Object)OrcFilters.toOrcPredicate((Expression)expression)).hasToString(predicate.toString());
        expression = CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, args, (DataType)DataTypes.BOOLEAN());
        predicate = new OrcFilters.Not((OrcFilters.Predicate)new OrcFilters.LessThanEquals("x", PredicateLeaf.Type.LONG, (Serializable)Integer.valueOf(10)));
        Assertions.assertThat((Object)OrcFilters.toOrcPredicate((Expression)expression)).hasToString(predicate.toString());
    }
}

