/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcColumnarRowInputFormatTest;
import org.apache.flink.orc.OrcColumnarRowSplitReader;
import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class OrcColumnarRowSplitReaderTest {
    protected static final int BATCH_SIZE = 10;
    private final DataType[] testSchemaFlat = new DataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.INT(), DataTypes.INT()};
    private final DataType[] testSchemaDecimal = new DataType[]{DataTypes.DECIMAL((int)10, (int)5)};
    private static Path testFileFlat;
    private static Path testFileDecimal;

    @BeforeAll
    static void setupFiles(@TempDir java.nio.file.Path tmpDir) {
        testFileFlat = OrcColumnarRowInputFormatTest.copyFileFromResource("test-data-flat.orc", tmpDir.resolve("test-data-flat.orc"));
        testFileDecimal = OrcColumnarRowInputFormatTest.copyFileFromResource("test-data-decimal.orc", tmpDir.resolve("test-data-decimal.orc"));
    }

    @Test
    void testReadFileInSplits() throws IOException {
        FileInputSplit[] splits = OrcColumnarRowSplitReaderTest.createSplits(testFileFlat, 4);
        long cnt = 0L;
        long totalF0 = 0L;
        for (FileInputSplit split : splits) {
            try (OrcColumnarRowSplitReader reader = this.createReader(new int[]{0, 1}, this.testSchemaFlat, new HashMap<String, Object>(), split);){
                while (!reader.reachedEnd()) {
                    RowData row = reader.nextRecord(null);
                    Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                    totalF0 += (long)row.getInt(0);
                    Assertions.assertThat((String)row.getString(1).toString()).isNotNull();
                    ++cnt;
                }
            }
        }
        Assertions.assertThat((long)cnt).isEqualTo(1920800L);
        Assertions.assertThat((long)totalF0).isEqualTo(1844737280400L);
    }

    @Test
    void testReadDecimalTypeFile() throws IOException {
        FileInputSplit[] splits = OrcColumnarRowSplitReaderTest.createSplits(testFileDecimal, 1);
        try (OrcColumnarRowSplitReader reader = this.createReader(new int[]{0}, this.testSchemaDecimal, new HashMap<String, Object>(), splits[0]);){
            Assertions.assertThat((boolean)reader.reachedEnd()).isFalse();
            RowData row = reader.nextRecord(null);
            Assertions.assertThat((Object)row).isNotNull();
            Assertions.assertThat((int)row.getArity()).isEqualTo(1);
            Assertions.assertThat((Comparable)row.getDecimal(0, 10, 5)).isEqualTo((Object)DecimalDataUtils.castFrom((double)-1000.5, (int)10, (int)5));
            long cnt = 1L;
            long nullCount = 0L;
            while (!reader.reachedEnd()) {
                row = reader.nextRecord(null);
                if (!row.isNullAt(0)) {
                    Assertions.assertThat((Comparable)row.getDecimal(0, 10, 5)).isNotNull();
                } else {
                    ++nullCount;
                }
                ++cnt;
            }
            Assertions.assertThat((long)cnt).isEqualTo(6000L);
            Assertions.assertThat((long)nullCount).isEqualTo(2000L);
        }
    }

    @Test
    void testReadFileWithSelectFields() throws IOException {
        FileInputSplit[] splits = OrcColumnarRowSplitReaderTest.createSplits(testFileFlat, 4);
        long cnt = 0L;
        long totalF0 = 0L;
        HashMap<String, Object> partSpec = new HashMap<String, Object>();
        partSpec.put("f1", 1);
        partSpec.put("f3", 3L);
        partSpec.put("f5", "f5");
        partSpec.put("f8", BigDecimal.valueOf(5.333));
        partSpec.put("f13", "f13");
        for (FileInputSplit split : splits) {
            try (OrcColumnarRowSplitReader reader = this.createReader(new int[]{8, 1, 3, 0, 5, 2}, new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.STRING(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.INT(), DataTypes.DECIMAL((int)10, (int)5), DataTypes.STRING(), DataTypes.INT(), DataTypes.INT(), DataTypes.STRING(), DataTypes.INT()}, partSpec, split);){
                while (!reader.reachedEnd()) {
                    RowData row = reader.nextRecord(null);
                    Assertions.assertThat((boolean)row.isNullAt(3)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(5)).isFalse();
                    totalF0 += (long)row.getInt(3);
                    Assertions.assertThat((String)row.getString(5).toString()).isNotNull();
                    Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(2)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(4)).isFalse();
                    Assertions.assertThat((Comparable)row.getDecimal(0, 10, 5)).isEqualTo((Object)DecimalDataUtils.castFrom((double)5.333, (int)10, (int)5));
                    Assertions.assertThat((int)row.getInt(1)).isEqualTo(1);
                    Assertions.assertThat((long)row.getLong(2)).isEqualTo(3L);
                    Assertions.assertThat((String)row.getString(4).toString()).isEqualTo("f5");
                    ++cnt;
                }
            }
        }
        Assertions.assertThat((long)cnt).isEqualTo(1920800L);
        Assertions.assertThat((long)totalF0).isEqualTo(1844737280400L);
    }

    @Test
    void testReadFileWithPartitionValues() throws IOException {
        FileInputSplit[] splits = OrcColumnarRowSplitReaderTest.createSplits(testFileFlat, 4);
        long cnt = 0L;
        long totalF0 = 0L;
        for (FileInputSplit split : splits) {
            try (OrcColumnarRowSplitReader reader = this.createReader(new int[]{2, 0, 1}, this.testSchemaFlat, new HashMap<String, Object>(), split);){
                while (!reader.reachedEnd()) {
                    RowData row = reader.nextRecord(null);
                    Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(2)).isFalse();
                    Assertions.assertThat((String)row.getString(0).toString()).isNotNull();
                    totalF0 += (long)row.getInt(1);
                    Assertions.assertThat((String)row.getString(2).toString()).isNotNull();
                    ++cnt;
                }
            }
        }
        Assertions.assertThat((long)cnt).isEqualTo(1920800L);
        Assertions.assertThat((long)totalF0).isEqualTo(1844737280400L);
    }

    protected void prepareReadFileWithTypes(String file, int rowSize) throws IOException {
        TypeDescription schema = TypeDescription.fromString((String)"struct<f0:float,f1:double,f2:timestamp,f3:tinyint,f4:smallint>");
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(file);
        Configuration conf = new Configuration();
        Writer writer = OrcFile.createWriter((org.apache.hadoop.fs.Path)filePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch(rowSize);
        DoubleColumnVector col0 = (DoubleColumnVector)batch.cols[0];
        DoubleColumnVector col1 = (DoubleColumnVector)batch.cols[1];
        TimestampColumnVector col2 = (TimestampColumnVector)batch.cols[2];
        LongColumnVector col3 = (LongColumnVector)batch.cols[3];
        LongColumnVector col4 = (LongColumnVector)batch.cols[4];
        col0.noNulls = false;
        col1.noNulls = false;
        col2.noNulls = false;
        col3.noNulls = false;
        col4.noNulls = false;
        for (int i = 0; i < rowSize - 1; ++i) {
            col0.vector[i] = i;
            col1.vector[i] = i;
            Timestamp timestamp = OrcColumnarRowSplitReaderTest.toTimestamp(i);
            col2.time[i] = timestamp.getTime();
            col2.nanos[i] = timestamp.getNanos();
            col3.vector[i] = i;
            col4.vector[i] = i;
        }
        col0.isNull[rowSize - 1] = true;
        col1.isNull[rowSize - 1] = true;
        col2.isNull[rowSize - 1] = true;
        col3.isNull[rowSize - 1] = true;
        col4.isNull[rowSize - 1] = true;
        batch.size = rowSize;
        writer.addRowBatch(batch);
        batch.reset();
        writer.close();
    }

    @Test
    void testReadFileWithTypes(@TempDir File folder) throws IOException {
        String file = new File(folder, "testOrc").getPath();
        int rowSize = 1024;
        this.prepareReadFileWithTypes(file, rowSize);
        FileInputSplit split = OrcColumnarRowSplitReaderTest.createSplits(new Path(file), 1)[0];
        int cnt = 0;
        HashMap<String, Object> partSpec = new HashMap<String, Object>();
        partSpec.put("f5", true);
        partSpec.put("f6", new Date(562423L));
        partSpec.put("f7", LocalDateTime.of(1999, 1, 1, 1, 1));
        partSpec.put("f8", 6.6);
        partSpec.put("f9", null);
        partSpec.put("f10", null);
        partSpec.put("f11", null);
        partSpec.put("f12", null);
        partSpec.put("f13", null);
        try (OrcColumnarRowSplitReader reader = this.createReader(new int[]{2, 0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, new DataType[]{DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.TIMESTAMP(), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.BOOLEAN(), DataTypes.DATE(), DataTypes.TIMESTAMP(), DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.INT(), DataTypes.STRING(), DataTypes.TIMESTAMP(), DataTypes.DECIMAL((int)5, (int)3)}, partSpec, split);){
            while (!reader.reachedEnd()) {
                RowData row = reader.nextRecord(null);
                if (cnt == rowSize - 1) {
                    Assertions.assertThat((boolean)row.isNullAt(0)).isTrue();
                    Assertions.assertThat((boolean)row.isNullAt(1)).isTrue();
                    Assertions.assertThat((boolean)row.isNullAt(2)).isTrue();
                    Assertions.assertThat((boolean)row.isNullAt(3)).isTrue();
                    Assertions.assertThat((boolean)row.isNullAt(4)).isTrue();
                } else {
                    Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(2)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(3)).isFalse();
                    Assertions.assertThat((boolean)row.isNullAt(4)).isFalse();
                    Assertions.assertThat((Comparable)row.getTimestamp(0, 9)).isEqualTo((Object)TimestampData.fromTimestamp((Timestamp)OrcColumnarRowSplitReaderTest.toTimestamp(cnt)));
                    Assertions.assertThat((float)row.getFloat(1)).isEqualTo((float)cnt);
                    Assertions.assertThat((double)row.getDouble(2)).isEqualTo((double)cnt);
                    Assertions.assertThat((byte)row.getByte(3)).isEqualTo((byte)cnt);
                    Assertions.assertThat((short)row.getShort(4)).isEqualTo((short)cnt);
                }
                Assertions.assertThat((boolean)row.getBoolean(5)).isTrue();
                Assertions.assertThat((String)DateTimeUtils.toSQLDate((int)row.getInt(6)).toString()).isEqualTo(new Date(562423L).toString());
                Assertions.assertThat((LocalDateTime)row.getTimestamp(7, 9).toLocalDateTime()).isEqualTo((Object)LocalDateTime.of(1999, 1, 1, 1, 1));
                Assertions.assertThat((double)row.getDouble(8)).isEqualTo(6.6);
                Assertions.assertThat((boolean)row.isNullAt(9)).isTrue();
                Assertions.assertThat((boolean)row.isNullAt(10)).isTrue();
                Assertions.assertThat((boolean)row.isNullAt(11)).isTrue();
                Assertions.assertThat((boolean)row.isNullAt(12)).isTrue();
                Assertions.assertThat((boolean)row.isNullAt(13)).isTrue();
                ++cnt;
            }
        }
        Assertions.assertThat((int)cnt).isEqualTo(rowSize);
    }

    @Test
    void testReachEnd() throws Exception {
        FileInputSplit[] splits = OrcColumnarRowSplitReaderTest.createSplits(testFileFlat, 1);
        try (OrcColumnarRowSplitReader reader = this.createReader(new int[]{0, 1}, this.testSchemaFlat, new HashMap<String, Object>(), splits[0]);){
            while (!reader.reachedEnd()) {
                reader.nextRecord(null);
            }
            Assertions.assertThat((boolean)reader.reachedEnd()).isTrue();
        }
    }

    protected static Timestamp toTimestamp(int i) {
        return new Timestamp(i + 1000, i % 12 + 1, i % 28 + 1, i % 24, i % 60, i % 60, i * 1000 + i);
    }

    protected OrcColumnarRowSplitReader createReader(int[] selectedFields, DataType[] fullTypes, Map<String, Object> partitionSpec, FileInputSplit split) throws IOException {
        return OrcSplitReaderUtil.genPartColumnarRowReader((String)"2.3.0", (Configuration)new Configuration(), (String[])((String[])IntStream.range(0, fullTypes.length).mapToObj(i -> "f" + i).toArray(String[]::new)), (DataType[])fullTypes, partitionSpec, (int[])selectedFields, new ArrayList(), (int)10, (Path)split.getPath(), (long)split.getStart(), (long)split.getLength());
    }

    private static FileInputSplit[] createSplits(Path path, int minNumSplits) throws IOException {
        return new DummyFileInputFormat(path).createInputSplits(minNumSplits);
    }

    private static class DummyFileInputFormat
    extends FileInputFormat<Row> {
        private static final long serialVersionUID = 1L;

        private DummyFileInputFormat(Path path) {
            super(path);
        }

        public boolean reachedEnd() {
            throw new UnsupportedOperationException();
        }

        public Row nextRecord(Row reuse) {
            throw new UnsupportedOperationException();
        }
    }
}

