/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai.com.fasterxml.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import org.apache.flink.model.openai.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import org.apache.flink.model.openai.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;

public class YearSerializer
extends JSR310FormattedSerializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearSerializer INSTANCE = new YearSerializer();

    protected YearSerializer() {
        this((DateTimeFormatter)null);
    }

    public YearSerializer(DateTimeFormatter formatter) {
        super(Year.class, formatter);
    }

    protected YearSerializer(YearSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        super(base, useTimestamp, formatter, null);
    }

    protected YearSerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        return new YearSerializer(this, useTimestamp, formatter);
    }

    @Override
    public void serialize(Year year, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            generator.writeNumber(year.getValue());
        } else {
            String str = this._formatter == null ? year.toString() : year.format(this._formatter);
            generator.writeString(str);
        }
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor2.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider) {
        return this.useTimestamp(provider) ? JsonToken.VALUE_NUMBER_INT : JsonToken.VALUE_STRING;
    }
}

