/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.ScheduledReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.dropwizard.metrics.DropwizardHistogramWrapper;
import org.apache.flink.dropwizard.metrics.DropwizardMeterWrapper;
import org.apache.flink.dropwizard.metrics.FlinkCounterWrapper;
import org.apache.flink.dropwizard.metrics.FlinkGaugeWrapper;
import org.apache.flink.dropwizard.metrics.FlinkHistogramWrapper;
import org.apache.flink.dropwizard.metrics.FlinkMeterWrapper;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public abstract class ScheduledDropwizardReporter
implements MetricReporter,
Scheduled,
Reporter,
CharacterFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ARG_HOST = "host";
    public static final String ARG_PORT = "port";
    public static final String ARG_PREFIX = "prefix";
    public static final String ARG_CONVERSION_RATE = "rateConversion";
    public static final String ARG_CONVERSION_DURATION = "durationConversion";
    protected final MetricRegistry registry;
    protected ScheduledReporter reporter;
    private final Map<Gauge<?>, String> gauges = new HashMap();
    private final Map<Counter, String> counters = new HashMap<Counter, String>();
    private final Map<Histogram, String> histograms = new HashMap<Histogram, String>();
    private final Map<Meter, String> meters = new HashMap<Meter, String>();

    protected ScheduledDropwizardReporter() {
        this.registry = new MetricRegistry();
    }

    @VisibleForTesting
    Map<Counter, String> getCounters() {
        return this.counters;
    }

    @VisibleForTesting
    Map<Meter, String> getMeters() {
        return this.meters;
    }

    @VisibleForTesting
    Map<Gauge<?>, String> getGauges() {
        return this.gauges;
    }

    @VisibleForTesting
    Map<Histogram, String> getHistograms() {
        return this.histograms;
    }

    public void open(MetricConfig config) {
        this.reporter = this.getReporter(config);
    }

    public void close() {
        this.reporter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(org.apache.flink.metrics.Metric metric, String metricName, MetricGroup group) {
        String fullName = group.getMetricIdentifier(metricName, (CharacterFilter)this);
        ScheduledDropwizardReporter scheduledDropwizardReporter = this;
        synchronized (scheduledDropwizardReporter) {
            switch (metric.getMetricType()) {
                case COUNTER: {
                    this.counters.put((Counter)metric, fullName);
                    this.registry.register(fullName, (Metric)new FlinkCounterWrapper((Counter)metric));
                    break;
                }
                case GAUGE: {
                    this.gauges.put((Gauge)metric, fullName);
                    this.registry.register(fullName, FlinkGaugeWrapper.fromGauge((Gauge)metric));
                    break;
                }
                case HISTOGRAM: {
                    Histogram histogram = (Histogram)metric;
                    this.histograms.put(histogram, fullName);
                    if (histogram instanceof DropwizardHistogramWrapper) {
                        this.registry.register(fullName, (Metric)((DropwizardHistogramWrapper)histogram).getDropwizardHistogram());
                        break;
                    }
                    this.registry.register(fullName, (Metric)new FlinkHistogramWrapper(histogram));
                    break;
                }
                case METER: {
                    Meter meter = (Meter)metric;
                    this.meters.put(meter, fullName);
                    if (meter instanceof DropwizardMeterWrapper) {
                        this.registry.register(fullName, (Metric)((DropwizardMeterWrapper)meter).getDropwizardMeter());
                        break;
                    }
                    this.registry.register(fullName, (Metric)new FlinkMeterWrapper(meter));
                    break;
                }
                default: {
                    this.log.warn("Cannot add metric of type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(org.apache.flink.metrics.Metric metric, String metricName, MetricGroup group) {
        ScheduledDropwizardReporter scheduledDropwizardReporter = this;
        synchronized (scheduledDropwizardReporter) {
            String fullName;
            switch (metric.getMetricType()) {
                case COUNTER: {
                    fullName = this.counters.remove(metric);
                    break;
                }
                case GAUGE: {
                    fullName = this.gauges.remove(metric);
                    break;
                }
                case HISTOGRAM: {
                    fullName = this.histograms.remove(metric);
                    break;
                }
                case METER: {
                    fullName = this.meters.remove(metric);
                    break;
                }
                default: {
                    fullName = null;
                }
            }
            if (fullName != null) {
                this.registry.remove(fullName);
            }
        }
    }

    public String filterCharacters(String metricName) {
        char[] chars = null;
        int strLen = metricName.length();
        int pos = 0;
        block4: for (int i = 0; i < strLen; ++i) {
            char c = metricName.charAt(i);
            switch (c) {
                case '.': {
                    if (chars == null) {
                        chars = metricName.toCharArray();
                    }
                    chars[pos++] = 45;
                    continue block4;
                }
                case '\"': {
                    if (chars != null) continue block4;
                    chars = metricName.toCharArray();
                    continue block4;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? metricName : new String(chars, 0, pos);
    }

    public void report() {
        SortedMap gauges = this.registry.getGauges();
        SortedMap counters = this.registry.getCounters();
        SortedMap histograms = this.registry.getHistograms();
        SortedMap meters = this.registry.getMeters();
        SortedMap timers = this.registry.getTimers();
        this.reporter.report(gauges, counters, histograms, meters, timers);
    }

    public abstract ScheduledReporter getReporter(MetricConfig var1);
}

