/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MetricOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.URLUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;

public abstract class MetricOperationsImpl<T, L>
extends OperationSupport
implements MetricOperation<T, L> {
    public static final String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1/";
    private final Class<L> apiTypeListClass;
    private final Class<T> apiTypeClass;

    public MetricOperationsImpl(OperationContext operationContext, Class<T> apiTypeClass, Class<L> apiTypeListClass) {
        super(operationContext);
        this.apiTypeClass = apiTypeClass;
        this.apiTypeListClass = apiTypeListClass;
    }

    @Override
    public L metrics() {
        try {
            return this.handleMetric(this.getMetricEndpointUrl(), this.apiTypeListClass);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable(exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
    }

    @Override
    public T metric() {
        try {
            return this.handleMetric(this.getMetricEndpointUrl(), this.apiTypeClass);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable(exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
    }

    @Override
    public L metrics(Map<String, Object> labelsMap) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labelsMap.forEach((k, v) -> labels.put((String)k, v.toString()));
        return this.withLabels(labels).metrics();
    }

    protected String getMetricEndpointUrlWithPlural(String plural) {
        Object result = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL);
        if (this.isResourceNamespaced() && this.namespace != null) {
            result = (String)result + "namespaces/" + this.namespace + "/";
        }
        result = (String)result + plural;
        if (this.context.getName() != null) {
            result = (String)result + "/" + this.context.getName();
        }
        if (Utils.isNotNullOrEmpty(this.context.getLabels())) {
            result = this.getUrlWithLabels((String)result, this.context.getLabels());
        }
        return result;
    }

    private String getMetricEndpointUrl() {
        return this.getMetricEndpointUrlWithPlural(this.context.getPlural());
    }

    private String getUrlWithLabels(String baseUrl, Map<String, String> labels) {
        URLUtils.URLBuilder httpUrlBuilder = new URLUtils.URLBuilder(baseUrl);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        httpUrlBuilder.addQueryParameter("labelSelector", sb.substring(0, sb.toString().length() - 1));
        return httpUrlBuilder.toString();
    }
}

