/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeSystemInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.ConditionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.ConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddressBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddressFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineDeletionStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineDeletionStatusBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineDeletionStatusFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineV1Beta2Status;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineV1Beta2StatusBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineV1Beta2StatusFluent;

public class MachineStatusFluent<A extends MachineStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<MachineAddressBuilder> addresses = new ArrayList();
    private Boolean bootstrapReady;
    private String certificatesExpiryDate;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private MachineDeletionStatusBuilder deletion;
    private String failureMessage;
    private String failureReason;
    private Boolean infrastructureReady;
    private String lastUpdated;
    private NodeSystemInfoBuilder nodeInfo;
    private ObjectReferenceBuilder nodeRef;
    private Long observedGeneration;
    private String phase;
    private MachineV1Beta2StatusBuilder v1beta2;
    private Map<String, Object> additionalProperties;

    public MachineStatusFluent() {
    }

    public MachineStatusFluent(MachineStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineStatus instance) {
        MachineStatus machineStatus = instance = instance != null ? instance : new MachineStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withBootstrapReady(instance.getBootstrapReady());
            this.withCertificatesExpiryDate(instance.getCertificatesExpiryDate());
            this.withConditions(instance.getConditions());
            this.withDeletion(instance.getDeletion());
            this.withFailureMessage(instance.getFailureMessage());
            this.withFailureReason(instance.getFailureReason());
            this.withInfrastructureReady(instance.getInfrastructureReady());
            this.withLastUpdated(instance.getLastUpdated());
            this.withNodeInfo(instance.getNodeInfo());
            this.withNodeRef(instance.getNodeRef());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withV1beta2(instance.getV1beta2());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, MachineAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        MachineAddressBuilder builder = new MachineAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToAddresses(int index, MachineAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        MachineAddressBuilder builder = new MachineAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToAddresses(MachineAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToAddresses(Collection<MachineAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromAddresses(MachineAddress ... items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAddresses(Collection<MachineAddress> items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAddresses(Predicate<MachineAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<MachineAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            MachineAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MachineAddress> buildAddresses() {
        return this.addresses != null ? MachineStatusFluent.build(this.addresses) : null;
    }

    public MachineAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public MachineAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public MachineAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public MachineAddress buildMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
        for (MachineAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
        for (MachineAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<MachineAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (MachineAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    public A withAddresses(MachineAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (MachineAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new MachineAddress(address, type));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(MachineAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, MachineAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public Boolean getBootstrapReady() {
        return this.bootstrapReady;
    }

    public A withBootstrapReady(Boolean bootstrapReady) {
        this.bootstrapReady = bootstrapReady;
        return (A)this;
    }

    public boolean hasBootstrapReady() {
        return this.bootstrapReady != null;
    }

    public String getCertificatesExpiryDate() {
        return this.certificatesExpiryDate;
    }

    public A withCertificatesExpiryDate(String certificatesExpiryDate) {
        this.certificatesExpiryDate = certificatesExpiryDate;
        return (A)this;
    }

    public boolean hasCertificatesExpiryDate() {
        return this.certificatesExpiryDate != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? MachineStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public MachineDeletionStatus buildDeletion() {
        return this.deletion != null ? this.deletion.build() : null;
    }

    public A withDeletion(MachineDeletionStatus deletion) {
        this._visitables.remove("deletion");
        if (deletion != null) {
            this.deletion = new MachineDeletionStatusBuilder(deletion);
            this._visitables.get("deletion").add(this.deletion);
        } else {
            this.deletion = null;
            this._visitables.get("deletion").remove(this.deletion);
        }
        return (A)this;
    }

    public boolean hasDeletion() {
        return this.deletion != null;
    }

    public A withNewDeletion(String nodeDrainStartTime, String waitForNodeVolumeDetachStartTime) {
        return this.withDeletion(new MachineDeletionStatus(nodeDrainStartTime, waitForNodeVolumeDetachStartTime));
    }

    public DeletionNested<A> withNewDeletion() {
        return new DeletionNested(null);
    }

    public DeletionNested<A> withNewDeletionLike(MachineDeletionStatus item) {
        return new DeletionNested(item);
    }

    public DeletionNested<A> editDeletion() {
        return this.withNewDeletionLike(Optional.ofNullable(this.buildDeletion()).orElse(null));
    }

    public DeletionNested<A> editOrNewDeletion() {
        return this.withNewDeletionLike(Optional.ofNullable(this.buildDeletion()).orElse(new MachineDeletionStatusBuilder().build()));
    }

    public DeletionNested<A> editOrNewDeletionLike(MachineDeletionStatus item) {
        return this.withNewDeletionLike(Optional.ofNullable(this.buildDeletion()).orElse(item));
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public A withFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return (A)this;
    }

    public boolean hasFailureMessage() {
        return this.failureMessage != null;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public A withFailureReason(String failureReason) {
        this.failureReason = failureReason;
        return (A)this;
    }

    public boolean hasFailureReason() {
        return this.failureReason != null;
    }

    public Boolean getInfrastructureReady() {
        return this.infrastructureReady;
    }

    public A withInfrastructureReady(Boolean infrastructureReady) {
        this.infrastructureReady = infrastructureReady;
        return (A)this;
    }

    public boolean hasInfrastructureReady() {
        return this.infrastructureReady != null;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)this;
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public NodeSystemInfo buildNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    public A withNodeInfo(NodeSystemInfo nodeInfo) {
        this._visitables.remove("nodeInfo");
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.get("nodeInfo").add(this.nodeInfo);
        } else {
            this.nodeInfo = null;
            this._visitables.get("nodeInfo").remove(this.nodeInfo);
        }
        return (A)this;
    }

    public boolean hasNodeInfo() {
        return this.nodeInfo != null;
    }

    public NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNested(null);
    }

    public NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNested(item);
    }

    public NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(null));
    }

    public NodeInfoNested<A> editOrNewNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(new NodeSystemInfoBuilder().build()));
    }

    public NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(item));
    }

    public ObjectReference buildNodeRef() {
        return this.nodeRef != null ? this.nodeRef.build() : null;
    }

    public A withNodeRef(ObjectReference nodeRef) {
        this._visitables.remove("nodeRef");
        if (nodeRef != null) {
            this.nodeRef = new ObjectReferenceBuilder(nodeRef);
            this._visitables.get("nodeRef").add(this.nodeRef);
        } else {
            this.nodeRef = null;
            this._visitables.get("nodeRef").remove(this.nodeRef);
        }
        return (A)this;
    }

    public boolean hasNodeRef() {
        return this.nodeRef != null;
    }

    public NodeRefNested<A> withNewNodeRef() {
        return new NodeRefNested(null);
    }

    public NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
        return new NodeRefNested(item);
    }

    public NodeRefNested<A> editNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(null));
    }

    public NodeRefNested<A> editOrNewNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public MachineV1Beta2Status buildV1beta2() {
        return this.v1beta2 != null ? this.v1beta2.build() : null;
    }

    public A withV1beta2(MachineV1Beta2Status v1beta2) {
        this._visitables.remove("v1beta2");
        if (v1beta2 != null) {
            this.v1beta2 = new MachineV1Beta2StatusBuilder(v1beta2);
            this._visitables.get("v1beta2").add(this.v1beta2);
        } else {
            this.v1beta2 = null;
            this._visitables.get("v1beta2").remove(this.v1beta2);
        }
        return (A)this;
    }

    public boolean hasV1beta2() {
        return this.v1beta2 != null;
    }

    public V1beta2Nested<A> withNewV1beta2() {
        return new V1beta2Nested(null);
    }

    public V1beta2Nested<A> withNewV1beta2Like(MachineV1Beta2Status item) {
        return new V1beta2Nested(item);
    }

    public V1beta2Nested<A> editV1beta2() {
        return this.withNewV1beta2Like(Optional.ofNullable(this.buildV1beta2()).orElse(null));
    }

    public V1beta2Nested<A> editOrNewV1beta2() {
        return this.withNewV1beta2Like(Optional.ofNullable(this.buildV1beta2()).orElse(new MachineV1Beta2StatusBuilder().build()));
    }

    public V1beta2Nested<A> editOrNewV1beta2Like(MachineV1Beta2Status item) {
        return this.withNewV1beta2Like(Optional.ofNullable(this.buildV1beta2()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineStatusFluent that = (MachineStatusFluent)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapReady, that.bootstrapReady)) {
            return false;
        }
        if (!Objects.equals(this.certificatesExpiryDate, that.certificatesExpiryDate)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.deletion, that.deletion)) {
            return false;
        }
        if (!Objects.equals(this.failureMessage, that.failureMessage)) {
            return false;
        }
        if (!Objects.equals(this.failureReason, that.failureReason)) {
            return false;
        }
        if (!Objects.equals(this.infrastructureReady, that.infrastructureReady)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals(this.nodeInfo, that.nodeInfo)) {
            return false;
        }
        if (!Objects.equals(this.nodeRef, that.nodeRef)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.v1beta2, that.v1beta2)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.bootstrapReady, this.certificatesExpiryDate, this.conditions, this.deletion, this.failureMessage, this.failureReason, this.infrastructureReady, this.lastUpdated, this.nodeInfo, this.nodeRef, this.observedGeneration, this.phase, this.v1beta2, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(String.valueOf(this.addresses) + ",");
        }
        if (this.bootstrapReady != null) {
            sb.append("bootstrapReady:");
            sb.append(this.bootstrapReady + ",");
        }
        if (this.certificatesExpiryDate != null) {
            sb.append("certificatesExpiryDate:");
            sb.append(this.certificatesExpiryDate + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.deletion != null) {
            sb.append("deletion:");
            sb.append(String.valueOf(this.deletion) + ",");
        }
        if (this.failureMessage != null) {
            sb.append("failureMessage:");
            sb.append(this.failureMessage + ",");
        }
        if (this.failureReason != null) {
            sb.append("failureReason:");
            sb.append(this.failureReason + ",");
        }
        if (this.infrastructureReady != null) {
            sb.append("infrastructureReady:");
            sb.append(this.infrastructureReady + ",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated + ",");
        }
        if (this.nodeInfo != null) {
            sb.append("nodeInfo:");
            sb.append(String.valueOf(this.nodeInfo) + ",");
        }
        if (this.nodeRef != null) {
            sb.append("nodeRef:");
            sb.append(String.valueOf(this.nodeRef) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.v1beta2 != null) {
            sb.append("v1beta2:");
            sb.append(String.valueOf(this.v1beta2) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withBootstrapReady() {
        return this.withBootstrapReady(true);
    }

    public A withInfrastructureReady() {
        return this.withInfrastructureReady(true);
    }

    public class V1beta2Nested<N>
    extends MachineV1Beta2StatusFluent<V1beta2Nested<N>>
    implements Nested<N> {
        MachineV1Beta2StatusBuilder builder;

        V1beta2Nested(MachineV1Beta2Status item) {
            this.builder = new MachineV1Beta2StatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluent.this.withV1beta2(this.builder.build());
        }

        public N endV1beta2() {
            return this.and();
        }
    }

    public class NodeRefNested<N>
    extends ObjectReferenceFluent<NodeRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        NodeRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluent.this.withNodeRef(this.builder.build());
        }

        public N endNodeRef() {
            return this.and();
        }
    }

    public class NodeInfoNested<N>
    extends NodeSystemInfoFluent<NodeInfoNested<N>>
    implements Nested<N> {
        NodeSystemInfoBuilder builder;

        NodeInfoNested(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluent.this.withNodeInfo(this.builder.build());
        }

        public N endNodeInfo() {
            return this.and();
        }
    }

    public class DeletionNested<N>
    extends MachineDeletionStatusFluent<DeletionNested<N>>
    implements Nested<N> {
        MachineDeletionStatusBuilder builder;

        DeletionNested(MachineDeletionStatus item) {
            this.builder = new MachineDeletionStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluent.this.withDeletion(this.builder.build());
        }

        public N endDeletion() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends MachineAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        MachineAddressBuilder builder;
        int index;

        AddressesNested(int index, MachineAddress item) {
            this.index = index;
            this.builder = new MachineAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

