/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Volume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeMount;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import org.apache.flink.util.Preconditions;

public class MountSecretsDecorator
extends AbstractKubernetesStepDecorator {
    private final AbstractKubernetesParameters kubernetesComponentConf;

    public MountSecretsDecorator(AbstractKubernetesParameters kubernetesComponentConf) {
        this.kubernetesComponentConf = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesComponentConf);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Pod podWithMount = this.decoratePod(flinkPod.getPodWithoutMainContainer());
        Container containerWithMount = this.decorateMainContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withPod(podWithMount).withMainContainer(containerWithMount).build();
    }

    private Container decorateMainContainer(Container container) {
        VolumeMount[] volumeMounts = (VolumeMount[])this.kubernetesComponentConf.getSecretNamesToMountPaths().entrySet().stream().map(secretNameToPath -> ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(this.secretVolumeName((String)secretNameToPath.getKey()))).withMountPath((String)secretNameToPath.getValue())).build()).toArray(VolumeMount[]::new);
        return ((ContainerBuilder)new ContainerBuilder(container).addToVolumeMounts(volumeMounts)).build();
    }

    private Pod decoratePod(Pod pod) {
        Volume[] volumes = (Volume[])this.kubernetesComponentConf.getSecretNamesToMountPaths().keySet().stream().map(secretName -> ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(this.secretVolumeName((String)secretName))).withNewSecret().withSecretName((String)secretName)).endSecret()).build()).toArray(Volume[]::new);
        return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editOrNewSpec().addToVolumes(volumes)).endSpec()).build();
    }

    private String secretVolumeName(String secretName) {
        return secretName + "-volume";
    }
}

