/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal.KubernetesDeserializer;

public class KubernetesDeserializerForList
extends JsonDeserializer<List<KubernetesResource>> {
    private final KubernetesDeserializer kubernetesDeserializer = new KubernetesDeserializer();

    @Override
    public List<KubernetesResource> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (!node.isArray()) {
            throw new JsonMappingException(p, "Expected array but found " + String.valueOf((Object)node.getNodeType()));
        }
        ArrayList<KubernetesResource> ret = new ArrayList<KubernetesResource>();
        for (JsonNode item : node) {
            ret.add(this.kubernetesDeserializer.deserialize(p, item));
        }
        return ret;
    }
}

